/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class StandingWaveReflectionAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Stehende Welle", "Reflexion", "am festen Ende", "am losen Ende", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Animation", "Einzelschritte", "Einfallende Welle", "Reflektierte Welle", "Resultierende stehende Welle", "T", "K", "B", ""}, {"en", "Standing Wave", "Reflection", "from a fixed end", "from a free end", "Reset", "Start", "Pause", "Resume", "Slow motion", "Animation", "Single steps", "Incidenting wave", "Reflected wave", "Resultant standing wave", "T", "N", "A", ""}};
    private int[] gaps = new int[]{10, 5, 5, 10, 10, 10, 10, 5, 10, 10, 5, 5, 10, 0, 10};
    final int width = 720;
    final int height = 440;
    final int width0 = 480;
    final int yM = 220;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton buReset;
    StartButton buStart;
    JRadioButton rbFix;
    JRadioButton rbFree;
    JRadioButton rbAnim;
    JRadioButton rbStep;
    JCheckBox cbSlow;
    JCheckBox cb1;
    JCheckBox cb2;
    JCheckBox cb3;
    JComboBox coStep;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color color1;
    Color color2;
    Color color3;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String symbolPeriod;
    String symbolNode;
    String symbolAntinode;
    double t;
    boolean on;
    boolean slow;
    boolean singleStep;
    boolean w1;
    boolean w2;
    boolean w3;
    final int WL = 144;
    final int LEN = 432;
    final int AMPL = 80;
    final int NWL = 3;
    final int DIST = 6;
    final double PER = 10.0;
    final double OMEGA = 0.6283185307179586;
    final double K = 0.04363323129985824;
    double dPhi;
    double dt;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(720, 440);
    }

    @Override
    protected void initAttributes() {
        this.dPhi = Math.PI;
        this.t = 0.0;
        this.slow = false;
        this.on = false;
        this.w3 = true;
        this.w2 = true;
        this.w1 = true;
        this.dt = 1.25;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.color1 = this.getColor(Color.red, "color1");
        this.color2 = this.getColor(Color.blue, "color2");
        this.color3 = this.getColor(Color.black, "color3");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.symbolPeriod = this.getText(t[15], "symbolPeriod");
        this.symbolNode = this.getText(t[16], "symbolNode");
        this.symbolAntinode = this.getText(t[17], "symbolAntinode");
        this.coauthor = this.getText(t[18], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 480, 440);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(480, 0, 240, 440);
        this.pan.add(this.text01);
        ButtonGroup bg = new ButtonGroup();
        this.rbFix = new JRadioButton(this.text02, true);
        this.pan.add(this.rbFix, this.bgPanel, Color.black);
        bg.add(this.rbFix);
        this.rbFree = new JRadioButton(this.text03);
        this.pan.add(this.rbFree, this.bgPanel, Color.black);
        bg.add(this.rbFree);
        this.buReset = new ResetButton(this.text04);
        this.pan.add(this.buReset, this.colorButton1, Color.black);
        this.buStart = new StartButton(this.text05, this.text06, this.text07);
        this.pan.add(this.buStart, this.colorButton2, Color.black);
        this.cbSlow = new JCheckBox(this.text08);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        bg = new ButtonGroup();
        this.rbAnim = new JRadioButton(this.text09, true);
        this.pan.add(this.rbAnim, this.bgPanel, Color.black);
        bg.add(this.rbAnim);
        this.rbStep = new JRadioButton(this.text10);
        this.pan.add(this.rbStep, this.bgPanel, Color.black);
        bg.add(this.rbStep);
        this.coStep = new JComboBox();
        for (int i = 1; i <= 4; ++i) {
            if (i == 4) {
                i = 6;
            }
            this.coStep.addItem(this.symbolPeriod + "/" + 4 * i);
        }
        this.coStep.setSelectedIndex(1);
        this.pan.add(this.coStep, Color.white, Color.black);
        this.cb1 = new JCheckBox(this.text11, this.w1);
        this.pan.add(this.cb1, this.bgPanel, Color.black);
        this.cb2 = new JCheckBox(this.text12, this.w2);
        this.pan.add(this.cb2, this.bgPanel, Color.black);
        this.cb3 = new JCheckBox(this.text13, this.w3);
        this.pan.add(this.cb3, this.bgPanel, Color.black);
        this.pan.add(2003);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.rbFix.addActionListener(this);
        this.rbFree.addActionListener(this);
        this.buReset.addActionListener(this);
        this.buStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.rbAnim.addActionListener(this);
        this.rbStep.addActionListener(this);
        this.coStep.addActionListener(this);
        this.cb1.addActionListener(this);
        this.cb2.addActionListener(this);
        this.cb3.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on && !this.singleStep) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 10.0;
                }
                this.t += dt;
            }
            t0 = t1;
        }
    }

    double elong1(double x) {
        if (this.t < 30.0 - x * 0.04363323129985824 / 0.6283185307179586) {
            return 0.0;
        }
        double phi = 0.6283185307179586 * (this.t - 30.0) - 0.04363323129985824 * (432.0 - x);
        return 80.0 * Math.sin(phi);
    }

    double elong2(double x) {
        if (this.t < 30.0 + x * 0.04363323129985824 / 0.6283185307179586) {
            return 0.0;
        }
        double phi = 0.6283185307179586 * (this.t - 30.0) - 0.04363323129985824 * (432.0 + x) + this.dPhi;
        return 80.0 * Math.sin(phi);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.dPhi = this.rbFix.isSelected() ? Math.PI : 0.0;
        this.slow = this.cbSlow.isSelected();
        this.w1 = this.cb1.isSelected();
        this.w2 = this.cb2.isSelected();
        this.w3 = this.cb3.isSelected();
        this.singleStep = this.rbStep.isSelected();
        int i = this.coStep.getSelectedIndex();
        if (i == 3) {
            i = 5;
        }
        this.dt = 10.0 / (double)(4 * i + 4);
        Object o = ae.getSource();
        if (o == this.rbFix || o == this.rbFree || o == this.buReset) {
            this.buStart.setState(0);
            this.t = 0.0;
        } else if (o == this.rbStep || o == this.coStep) {
            this.buStart.setState(this.t > 0.0 ? 2 : 0);
            this.t = this.dt * Math.ceil(this.t / this.dt);
        } else if (o == this.buStart) {
            if (this.singleStep) {
                this.buStart.setState(2);
                this.t += this.dt;
            } else {
                this.buStart.setState();
            }
        }
        this.on = this.buStart.getState() == 1;
        this.cv.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, StandingWaveReflectionAP.this.bgCanvas);
            StandingWaveReflectionAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void drawSinus(Graphics2D g) {
            double x1 = 0.0;
            double e1 = StandingWaveReflectionAP.this.elong1(432.0 - x1);
            double e2 = StandingWaveReflectionAP.this.elong2(432.0 - x1);
            double e3 = e1 + e2;
            double y1w1 = 220.0 - e1;
            double y1w2 = 220.0 - e2;
            double y1w3 = 220.0 - e3;
            while (x1 < 432.0) {
                boolean stab;
                double x0 = x1;
                double y0w1 = y1w1;
                double y0w2 = y1w2;
                double y0w3 = y1w3;
                e1 = StandingWaveReflectionAP.this.elong1(432.0 - (x1 += 1.0));
                e2 = StandingWaveReflectionAP.this.elong2(432.0 - x1);
                e3 = e1 + e2;
                y1w1 = 220.0 - e1;
                y1w2 = 220.0 - e2;
                y1w3 = 220.0 - e3;
                boolean bl = stab = x0 % 6.0 == 0.0;
                if (StandingWaveReflectionAP.this.w1) {
                    g.setColor(StandingWaveReflectionAP.this.color1);
                    CanvasAP.line(g, x0, y0w1, x1, y1w1);
                    if (stab) {
                        CanvasAP.line(g, x0, y0w1, x0, 220.0);
                    }
                }
                if (StandingWaveReflectionAP.this.w2) {
                    g.setColor(StandingWaveReflectionAP.this.color2);
                    CanvasAP.line(g, x0, y0w2, x1, y1w2);
                    if (stab) {
                        CanvasAP.line(g, x1, y1w2, x1, 220.0);
                    }
                }
                if (!StandingWaveReflectionAP.this.w3) continue;
                g.setColor(StandingWaveReflectionAP.this.color3);
                CanvasAP.line(g, x0, y0w3, x1, y1w3);
                if (!stab) continue;
                CanvasAP.circle(g, x0, y0w3, 1.5, StandingWaveReflectionAP.this.color3, true);
            }
            g.setColor(StandingWaveReflectionAP.this.color1);
            if (StandingWaveReflectionAP.this.w1) {
                CanvasAP.line(g, x1, y1w1, x1, 220.0);
            }
            g.setColor(StandingWaveReflectionAP.this.color2);
            if (StandingWaveReflectionAP.this.w2) {
                CanvasAP.line(g, x1 + 1.0, y1w2, x1 + 1.0, 220.0);
            }
            if (StandingWaveReflectionAP.this.w3) {
                CanvasAP.circle(g, x1, y1w3, 1.5, StandingWaveReflectionAP.this.color3, true);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            g.setColor(Color.black);
            if (StandingWaveReflectionAP.this.dPhi > 0.0) {
                CanvasAP.line(g2, 432.0, 40.0, 432.0, 400.0);
            } else {
                for (int y = 40; y <= 400; y += 10) {
                    CanvasAP.line(g2, 432.0, y - 3, 432.0, y + 3);
                }
            }
            this.drawSinus(g2);
            g.setColor(Color.black);
            g.drawLine(0, 220, 432, 220);
            if (!StandingWaveReflectionAP.this.w3) {
                return;
            }
            CanvasAP.setAntiAliasing(g2, false);
            for (int i = 0; i <= 12; ++i) {
                boolean node = i % 2 == 0 && StandingWaveReflectionAP.this.dPhi == Math.PI || i % 2 == 1 && StandingWaveReflectionAP.this.dPhi == 0.0;
                String s = node ? StandingWaveReflectionAP.this.symbolNode : StandingWaveReflectionAP.this.symbolAntinode;
                int x = 432 - i * 144 / 4;
                if ((double)(432 - x) > 14.4 * (StandingWaveReflectionAP.this.t - 30.0)) break;
                g.drawString(s, x > 0 ? x - 3 : x, 233);
                CanvasAP.line(g2, x, 218.0, x, 222.0);
            }
        }
    }
}

