import random
import tkinter
import math


class Treap:
    r = 22

    used_priorities = set()  # not necessary, just for sure ;)

    class Node:
        def __init__(self, key):
            self.key = key
            temp = random.randrange(0, 1000)
            while temp in Treap.used_priorities:
                temp = random.randrange(0, 1000)

            Treap.used_priorities.add(temp)
            self.priority = temp
            self.left, self.right = None, None
            self.x, self.y = None, None

    def __init__(self, delay):
        self.canvas = tkinter.Canvas(width=1600, height=800)
        self.canvas.pack()
        self.root = None
        self.canvas.update()
        self.current_query = ''
        self.delay = delay
        with open('log.txt', 'w', encoding='utf8') as file:
            pass

    def obsahuje(self):

        def rek(node):
            res = []
            if node is not None:
                if node.left is not None:
                    res += [rek(node.left)]
                res += [{'k': node.key, 'p': node.priority}]
                if node.right is not None:
                    res += [rek(node.right)]
            return res

        res = rek(self.root)

        return res

    def split(self, key, node, left, right):
        if node is None:
            return None, None

        self.highlight(node, 'yellow', key)

        if key < node.key:
            left, node.left = self.split(key, node.left, left, node.left)
            right = node

        else:
            node.right, right = self.split(key, node.right, node.right, right)
            left = node

        res = self.draw(right, subtree=1)
        res += self.draw(left, subtree=-1)

        self.highlight(node, 'black')

        return left, right

    def merge(self, left_subtree=None, right_subtree=None):
        if left_subtree is None or right_subtree is None:
            if left_subtree:
                return left_subtree
            return right_subtree

        if left_subtree.priority > right_subtree.priority:
            left_subtree.right = self.merge(left_subtree.right, right_subtree)

            res = self.draw_helper(left_subtree, 300, 600, 100, merge=1)
            for obj in res:
                self.canvas.delete(obj)
            self.canvas.update()
            return left_subtree
        else:
            right_subtree.left = self.merge(left_subtree, right_subtree.left)

            res = self.draw_helper(right_subtree, 300, 600, 100, merge=1)
            for obj in res:
                self.canvas.delete(obj)
            self.canvas.update()
            return right_subtree

    def insert(self, node2insert, node):
        if node is None:
            return node2insert

        self.highlight(node, 'orange', node2insert.priority, False)

        res = self.draw_helper(node2insert, node.sir, node.x-2*self.r-10, node.y)

        if node2insert.priority > node.priority:
            self.highlight(node, 'red', node2insert.priority, False)
            left, right = self.split(node2insert.key, node, node.left, node.right)
            node2insert.left, node2insert.right = left, right

            self.highlight(node, 'black')

            for obj in res:
                self.canvas.delete(obj)
            self.canvas.update()

            return node2insert

        else:
            text = None
            if node2insert.key < node.key:
                if node.left is None:
                    text = self.canvas.create_text(node.x + 4 * self.r, node.y, text='Nemá ľavého syna\nTakže sem doľava')
                    self.canvas.update()
                    self.canvas.after(self.delay)
                node.left = self.insert(node2insert, node.left)
                self.canvas.update()
            else:
                if node.right is None:
                    text = self.canvas.create_text(node.x + 4 * self.r, node.y, text='Nemá pravého syna\nTakže sem doprava')
                    self.canvas.update()
                    self.canvas.after(self.delay)
                node.right = self.insert(node2insert, node.right)
                self.canvas.delete(text)
                self.canvas.update()

            if text is not None:
                self.canvas.delete(text)

            for obj in res:
                self.canvas.delete(obj)
            self.canvas.update()

            return node

    def remove(self, key, node):
        if node is None:
            return

        self.highlight(node, 'orange', key, True)

        if node.key == key:
            self.highlight(node, 'blue')
            res = self.merge(node.left, node.right)
            # self.highlight(node, 'black')

            return res

        else:
            if key < node.key:
                node.left = self.remove(key, node.left)
            else:
                node.right = self.remove(key, node.right)

            # self.highlight(node, 'black')

            return node

    def find(self, key, node):
        if node is None:
            return False

        self.highlight(node, 'orange', key, True)

        if node.key == key:
            self.highlight(node, 'blue')
            self.highlight(node, 'black')
            return True
        if node.key > key:
            res = self.find(key, node.left)

        else:
            res = self.find(key, node.right)

        # self.highlight(node, 'black')

        return res

    def draw_queries(self):
        class Button:
            def __init__(self, tkids, x1, y1, x2, y2, txt):
                self.tkids, self.x1, self.y1, self.x2, self.y2, self.txt = tkids, x1, y1, x2, y2, txt

        self.buttons = []
        x_s, y_s = 1270, 300
        x_d, y_d = 70, 70
        d = 20
        for i in range(5):
            for j in range(3):
                tkids = []
                text = ''
                if i == 0:
                    if j == 0:
                        text = 'Find'
                    if j == 1:
                        text = 'Delete'
                    if j == 2:
                        text = 'Insert'

                elif i == 4:
                    if j == 0:
                        text = '0'
                    if j == 1:
                        tkids.append(self.canvas.create_rectangle(x_s+j*(x_d+d), y_s+i*(y_d+d), x_s+j*(x_d+d)+2*x_d+d, y_s+i*(y_d + d)+y_d, fill='white'))
                        tkids.append(self.canvas.create_text(x_s+j*(x_d+d)+x_d, y_s+i*(y_d+d)+y_d/2, text='<x', font='consolas 15'))
                        self.buttons.append(Button(tkids, x_s+j*(x_d+d), y_s+i*(y_d+d), x_s+j*(x_d+d)+2*x_d+d, y_s+i*(y_d + d)+y_d, '<x'))
                        continue
                    if j == 2:
                        continue
                else:
                    text = str((i-1)*3+(j+1))
                tkids.append(self.canvas.create_rectangle(x_s+j*(x_d+d), y_s+i*(y_d+d), x_s+j*(x_d+d)+x_d, y_s+i*(y_d+d)+y_d, fill='white'))
                tkids.append(self.canvas.create_text(x_s+j*(x_d+d)+x_d/2, y_s+i*(y_d+d)+y_d/2, text=text, font='consolas 15'))
                self.buttons.append(Button(tkids, x_s+j*(x_d+d), y_s+i*(y_d+d), x_s+j*(x_d+d)+x_d, y_s+i*(y_d+d)+y_d, text))
        self.text_box = self.canvas.create_text(1400, 200, text=self.current_query)

    def draw_helper(self, node=None, sir=0, x=0, y=0, subtree=0, merge=0):
        res = self.draw(node, sir, x, y, subtree, merge)
        self.canvas.update()
        self.canvas.after(self.delay)
        return res

    def draw(self, node=None, sir=0, x=0, y=0, subtree=0, merge=0):
        self.canvas.update()

        res = []

        if subtree == 1:
            res.append(self.canvas.create_line(0, 500, 1200, 500, width='10'))
            res.append(self.canvas.create_line(800, 500, 800, 800, width='10'))
            sir, x, y = 200, 1000, 580
            res.append(self.canvas.create_text(1000, 520, text='Right subtree', font='consolas 15'))

        if subtree == -1:
            res.append(self.canvas.create_line(0, 500, 1200, 500, width='10'))
            res.append(self.canvas.create_line(400, 500, 400, 800, width='10'))
            sir, x, y = 200, 200, 580
            res.append(self.canvas.create_text(200, 520, text='Left subtree', font='consolas 15'))

        if merge == 1:
            res.append(self.canvas.create_line(0, 500, 1200, 500, width='10'))
            res.append(self.canvas.create_line(400, 500, 400, 800, width='10'))
            res.append(self.canvas.create_line(800, 500, 800, 800, width='10'))
            sir, x, y = 200, 600, 580
            res.append(self.canvas.create_text(600, 520, text='Merged subtree', font='consolas 15'))

        if sir == 0 and x == 0 and y == 0:
            sir, x, y = 600, 600, 100
            self.canvas.delete('all')
            self.canvas.create_line(1200, 0, 1200, 800, width='10')
            self.draw_queries()

        self.canvas.update()

        if node is None:
            return []

        if node.left is not None:
            res.append(self.canvas.create_line(x, y, x-sir/2, y+40))
            res += self.draw(node.left, sir//2, x-sir//2, y+40)

        if node.right is not None:
            res.append(self.canvas.create_line(x, y, x+sir/2, y+40))
            res += self.draw(node.right, sir//2, x+sir//2, y+40)

        node.sir, node.x, node.y = sir, x, y
        res.append(self.canvas.create_oval(x-self.r, y-self.r, x+self.r, y+self.r, fill='white'))
        res.append(self.canvas.create_text(x, y, text='k:'+str(node.key)+'\np:'+str(node.priority), font='consolas 9'))
        self.canvas.update()
        return res

    def highlight(self, node, color, cmp1=None, key=None):
        def op(a, b):
            if a != b:
                return '<' if a < b else '>'
            else:
                return '='

        def takze(a, b):
            return 'pravý podstrom\n   ide DOPRAVA' if a < b else 'ľavy podstrom\n   ide DOĽAVA'

        def kam(a, b, key):
            if key is True:
                if a < b:
                    return '\npozrime sa do\nľavého podstromu'
                elif a > b:
                    return '\npozrime sa do\npravého podstromu'
                else:
                    return ''
            if key is False:
                if a < b:
                    return '\ntakže nový vrchol\nmá byť nižšie'
                else:
                    return '\ntakže nový vrchol\nmá byť tu'

        self.canvas.create_oval(node.x-self.r, node.y-self.r, node.x+self.r, node.y+self.r, fill='', outline=color)
        text = ''

        if color == 'orange':
            cmp2, co = None, None

            if key is True:
                cmp2 = node.key
                co = 'kľúče'
            elif key is False:
                cmp2 = node.priority
                co = 'priority'
            if key is None:
                text = 'Tu?'
            else:
                text = 'Tu?\n(porovnávam ' + co + ')\n' + str(cmp1) + op(cmp1, cmp2) + str(cmp2) + kam(cmp1, cmp2, key)
        if color == 'blue':
            text = 'Našiel som\n' + str(node.key) + '==' + str(node.key)
        if color == 'yellow':
            text = '\nKam s tebou?\n    ' + str(cmp1) + op(cmp1, node.key) + str(node.key) + '\n' + 'toto a aj celý jeho\n' + takze(cmp1, node.key)
        if color == 'red':
            text = 'Sem by to malo ísť!\n' + str(cmp1) + op(cmp1, node.priority) + str(node.priority) + '\ntreba niečo urobiť\ns ním a jeho podstromom'

        if color != 'black':
            d = min(40, math.sqrt(((node.x+self.r+5) - (1000-50))**2 + ((node.y-self.r/2) - (30+70))**2)/2)
            self.canvas.create_line(node.x+self.r+5, node.y-self.r/2, 1000-50, 30+70, width=3, tag='t')
            alpha = math.atan2((-((node.x+self.r+5) - (1000-50))), -((node.y-self.r/2)-(30+70))) - math.radians(30)
            self.canvas.create_line(node.x+self.r+5, node.y-self.r/2, (node.x+self.r+5) + math.sin(alpha)*d, (node.y-self.r/2) + math.cos(alpha)*d, width=3, tag='t')
            alpha2 = math.radians(180-120)+alpha
            self.canvas.create_line(node.x+self.r+5, node.y-self.r/2, (node.x+self.r+5) + math.sin(alpha2)*d, (node.y-self.r/2) + math.cos(alpha2)*d, width=3, tag='t')
            self.canvas.create_text(1050, 55, text=text, font='consolas 13', tag='t')
        self.canvas.update()
        self.canvas.after(self.delay)
        self.canvas.delete('t')
        self.canvas.update()

    def insert_query(self, data):
        text = self.canvas.create_text(1050, 50, text='Skúsme najprv\ntaký vrchol nájsť...\nNie že by som ti neveril,\nale len tak, pre istotu...', font='consolas 12')
        self.canvas.update()
        self.canvas.after(self.delay)
        self.canvas.delete(text)
        self.canvas.update()

        with open('log.txt', 'a', encoding='utf8') as file:
            print('Query = Insert(', data, ')', sep='', file=file)
            print('Treap pred query obsahoval:', self.obsahuje(), file=file)

        if not self.find(data, self.root):
            node = self.Node(data)
            self.canvas.create_text(30, 30, text='Node to\ninsert:', font='consolas 9')
            self.canvas.create_text(250, 30, text='Insert', font='consolas 15')
            self.draw_helper(node, 40, 100, 50)

            self.root = self.insert(node, self.root)

        with open('log.txt', 'a', encoding='utf8') as file:
            print('Treap po query obsahuje:', self.obsahuje(), file=file)

    def delete_query(self, data):
        text = [self.canvas.create_text(250, 30, text='Delete', font='consolas 15')]
        text.append(self.canvas.create_oval(100 - self.r, 50 - self.r, 100 + self.r, 50 + self.r, fill='white'))
        text.append(self.canvas.create_text(100, 50, text='k : ' + str(data) + ' \n'))
        text.append(self.canvas.create_text(30, 30, text='Node to\ndelete:', font='consolas 9'))

        with open('log.txt', 'a', encoding='utf8') as file:
            print('Query = Delete(', data, ')', sep='', file=file)
            print('Treap pred query obsahoval:', self.obsahuje(), file=file)

        self.root = self.remove(data, self.root)
        with open('log.txt', 'a', encoding='utf8') as file:
            print('Treap po query obsahuje:', self.obsahuje(), file=file)

        for o in text:
            self.canvas.delete(o)

    def find_query(self, data):
        text = [self.canvas.create_text(250, 30, text='Find', font='consolas 15')]
        text.append(self.canvas.create_oval(100 - self.r, 50 - self.r, 100 + self.r, 50 + self.r, fill='white'))
        text.append(self.canvas.create_text(100, 50, text='k : ' + str(data) + ' \n'))
        text.append(self.canvas.create_text(30, 30, text='Node to\nfind:', font='consolas 9'))

        res = self.find(data, self.root)

        with open('log.txt', 'a', encoding='utf8') as file:
            print('Query = Find(', data, ')', sep='', file=file)
            print('Treap momentálne obsahuje:', self.obsahuje(), file=file)
            print('Prvok sa tam nachádza: ', str(res), sep='', file=file)

        if res is False:
            text.append(self.canvas.create_text(1050, 25, text='NEnašiel som vrchol\ns kľúčom '+str(data), font='consolas 13'))
            self.canvas.update()
            self.canvas.after(self.delay)

        if res is True:
            text.append(self.canvas.create_text(1050, 25, text='Našiel som vrchol\ns kľúčom '+str(data), font='consolas 13'))
            self.canvas.update()
            self.canvas.after(self.delay)

        for o in text:
            self.canvas.delete(o)

        return res

    def press_event(self, event):
        for i in range(len(self.buttons)):
            if self.buttons[i].x1 <= event.x <= self.buttons[i].x2 and self.buttons[i].y1 <= event.y <= self.buttons[i].y2:
                if self.buttons[i].txt in 'Find Delete Insert':
                    if self.current_query == '':
                        return
                    if self.buttons[i].txt == 'Find':
                        self.canvas.itemconfig(self.text_box, text='')
                        self.canvas.update()
                        q = self.current_query
                        self.current_query = ''
                        print(self.find_query(int(q)))
                    if self.buttons[i].txt == 'Delete':
                        self.canvas.itemconfig(self.text_box, text='')
                        self.canvas.update()
                        q = self.current_query
                        self.current_query = ''
                        self.delete_query(int(q))
                    if self.buttons[i].txt == 'Insert':
                        self.canvas.itemconfig(self.text_box, text='')
                        self.canvas.update()
                        q = self.current_query
                        self.current_query = ''
                        self.insert_query(int(q))
                    self.current_query = ''
                else:
                    if self.buttons[i].txt == '<x':
                        self.current_query = self.current_query[:-1]
                    else:
                        self.current_query += self.buttons[i].txt
                self.canvas.itemconfig(self.text_box, text=self.current_query)
        self.draw(self.root)
        self.canvas.update()

    def loop(self):

        self.draw(self.root)
        self.canvas.bind('<ButtonPress>', self.press_event)
        self.canvas.update()
        self.canvas.mainloop()


class Vizualizacia:

    def __init__(self):
        with open("delay.dat", 'r') as delay:
            self.t = Treap(int(delay.read()))
            self.zacni_vizualizovat()

    def zacni_vizualizovat(self):
        self.t.loop()


Vizualizacia()
