/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import RDG.Flight;
import RDG.SeatCount;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AircraftType {
    private Integer aircraft_type_id;
    private String aircraft_name;

    public Integer getAircraft_type_id() {
        return this.aircraft_type_id;
    }

    public void setAircraft_type_id(Integer aircraft_type_id) {
        this.aircraft_type_id = aircraft_type_id;
    }

    public String getAircraft_name() {
        return this.aircraft_name;
    }

    public void setAircraft_name(String name) {
        this.aircraft_name = name;
    }

    public String toString() {
        return "AircraftTypes{aircraft_id=" + this.aircraft_type_id + ", aircraft_name=" + this.aircraft_name + "}";
    }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO aircraft_types (aircraft_name) VALUES (?)", 1);){
            s.setString(1, this.aircraft_name);
            s.executeUpdate();
            try (ResultSet r = s.getGeneratedKeys();){
                r.next();
                this.aircraft_type_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (this.aircraft_type_id == null) {
            throw new IllegalStateException("aircraft_type_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE aircraft_types SET aircraft_name=? WHERE aircraft_type_id=?");){
            s.setString(1, this.aircraft_name);
            s.setInt(2, this.aircraft_type_id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException, Exception {
        if (this.aircraft_type_id == null) {
            throw new IllegalStateException("aircraft_type_id is not set");
        }
        SeatCount sdb = new SeatCount();
        sdb.setAircraft_type_id(this.aircraft_type_id);
        sdb.delete();
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM aircraft_types WHERE aircraft_type_id = ?");){
            s.setInt(1, this.aircraft_type_id);
            s.executeUpdate();
        }
    }

    public static void canReplaceAirplane(Integer new_aircraft, Integer flight_id) throws SQLException, Exception {
        Integer old_aircraft = 0;
        if (!AircraftType.exists(new_aircraft)) {
            throw new Exception("Aircraft w/ this id don't exists");
        }
        if (!Flight.exists(flight_id)) {
            throw new Exception("Flight w/ this id don't exists");
        }
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT class_id FROM seat_count_in_class WHERE aircraft_type_id=?");
        s.setInt(1, old_aircraft);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            PreparedStatement ps = DbContext.getConnection().prepareStatement("SELECT \"count\" FROM seat_count_in_class WHERE aircraft_type_id=? AND class_id=?");
            ps.setInt(1, new_aircraft);
            ps.setInt(2, rs.getInt("class_id"));
            ResultSet res_set = ps.executeQuery();
            while (rs.next()) {
                if (res_set.getInt(1) >= SeatCount.countBooked(rs.getInt("class_id"), old_aircraft, flight_id)) continue;
                throw new Exception("Nov\u00e9 lietadlo nem\u00e1 dos\u0165 miest nejakej triede");
            }
        }
    }

    public static boolean exists(int aircraft_type_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from aircraft_types WHERE aircraft_type_id=?");
        s.setInt(1, aircraft_type_id);
        return s.executeQuery().next();
    }
}

