/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Airport {
    private Integer airport_id;
    private String full_name;
    private String icao_code;
    private String iata_code;
    private Integer city_id;

    public String toString() {
        return "Airports{airport_id=" + this.airport_id + ", full_name=" + this.full_name + ", icao_code=" + this.icao_code + ", iata_code=" + this.iata_code + ", city_id=" + this.city_id + "}";
    }

    public Integer getAirport_id() {
        return this.airport_id;
    }

    public void setAirport_id(Integer airport_id) {
        this.airport_id = airport_id;
    }

    public String getFull_name() {
        return this.full_name;
    }

    public void setFull_name(String full_name) {
        this.full_name = full_name;
    }

    public String getIcao_code() {
        return this.icao_code;
    }

    public void setIcao_code(String icao_code) {
        this.icao_code = icao_code;
    }

    public String getIata_code() {
        return this.iata_code;
    }

    public void setIata_code(String iata_code) {
        this.iata_code = iata_code;
    }

    public Integer getCity_id() {
        return this.city_id;
    }

    public void setCity_id(Integer city_id) {
        this.city_id = city_id;
    }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO airports (full_name, icao_code, iata_code, city_id) VALUES (?,?,?,?)", 1);){
            s.setString(1, this.full_name);
            s.setString(2, this.icao_code);
            s.setString(3, this.iata_code);
            s.setInt(4, this.city_id);
            s.executeUpdate();
            try (ResultSet r = s.getGeneratedKeys();){
                r.next();
                this.airport_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (this.airport_id == null) {
            throw new IllegalStateException("airport_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE airports SET full_name = ?, icao_code = ?, iata_code = ?, city_id = ? WHERE airport_id = ?");){
            s.setString(1, this.full_name);
            s.setString(2, this.icao_code);
            s.setString(3, this.iata_code);
            s.setInt(4, this.city_id);
            s.setInt(5, this.airport_id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException, Exception {
        if (this.airport_id == null) {
            throw new IllegalStateException("airport_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM airports WHERE airport_id = ?");){
            s.setInt(1, this.airport_id);
            s.executeUpdate();
        }
    }

    public static boolean exists(int airport_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from airports WHERE airport_id=?");
        s.setInt(1, airport_id);
        return s.executeQuery().next();
    }
}

