/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import RDG.SeatCount;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class BoughtTicket {
    boolean canceled;
    int flight_id;
    int class_id;
    int passenger_id;
    int aircraft_type_id;
    int seat_id;

    public int getAircraft_type_id() {
        return this.aircraft_type_id;
    }

    public void setAircraft_type_id(int aircraft_type_id) {
        this.aircraft_type_id = aircraft_type_id;
    }

    public int getSeat_id() {
        return this.seat_id;
    }

    public void setSeat_id(int seat_id) {
        this.seat_id = seat_id;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public int getFlight_id() {
        return this.flight_id;
    }

    public void setFlight_id(int flight_id) {
        this.flight_id = flight_id;
    }

    public int getClass_id() {
        return this.class_id;
    }

    public void setClass_id(int class_id) {
        this.class_id = class_id;
    }

    public int getPassenger_id() {
        return this.passenger_id;
    }

    public void setPassenger_id(int passenger_id) {
        this.passenger_id = passenger_id;
    }

    public static int insert(Integer flight_id, Integer class_id, boolean canceled, Integer passenger_id) throws SQLException, Exception {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO bought_tickets (flight_id, class_id, canceled, passenger_id, seat_id) VALUES (?,?,?,?, null)", 1);){
            int n;
            block12: {
                s.setInt(1, flight_id);
                s.setInt(2, class_id);
                s.setBoolean(3, canceled);
                s.setInt(4, passenger_id);
                s.executeUpdate();
                ResultSet r = s.getGeneratedKeys();
                try {
                    r.next();
                    n = r.getInt(1);
                    if (r == null) break block12;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r.close();
            }
            return n;
        }
    }

    public static void cancel(Integer id) throws SQLException, Exception {
        if (!BoughtTicket.exists(id)) {
            throw new Exception("Ticket w/ this id don't exists");
        }
        if (BoughtTicket.ticketCanceled(id)) {
            throw new Exception("Ticket w/ this was already canceled");
        }
        PreparedStatement ps = DbContext.getConnection().prepareStatement("SELECT * FROM bought_tickets INNER JOIN flights ON bought_tickets.flight_id=flights.flight_id");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Timestamp day_ago;
            Timestamp departure = rs.getTimestamp("departure_time");
            if (departure.compareTo(day_ago = new Timestamp(System.currentTimeMillis() - 86400000L)) <= 0) continue;
            throw new Exception("Let o menej ako 24 hod\u00edn, nevie\u0161 ho zru\u0161i\u0165");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE bought_tickets SET canceled=true WHERE bought_ticket_id=?");){
            s.setInt(1, id);
            s.executeUpdate();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void findById(Integer bought_ticket_id) throws Exception {
        if (!BoughtTicket.exists(bought_ticket_id)) {
            throw new Exception("Ticket w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM bought_tickets INNER JOIN flights ON flights.flight_id=bought_tickets.flight_id WHERE bought_ticket_id=?");){
            s.setInt(1, bought_ticket_id);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                this.canceled = rs.getBoolean("canceled");
                this.flight_id = rs.getInt("flight_id");
                this.class_id = rs.getInt("class_id");
                this.passenger_id = rs.getInt("passenger_id");
                this.aircraft_type_id = rs.getInt("aircraft_type_id");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ticketCanceled(Integer id) throws Exception {
        if (!BoughtTicket.exists(id)) {
            throw new Exception("Ticket w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT canceled FROM bought_tickets WHERE bought_ticket_id=?");){
            s.setInt(1, id);
            ResultSet rs = s.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getBoolean(1);
            return bl;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return false;
    }

    public static boolean exists(int ticket_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from bought_tickets WHERE bought_ticket_id=?");
        s.setInt(1, ticket_id);
        return s.executeQuery().next();
    }

    public static void reserveSeat(Integer seat_id, Integer ticket_id) throws SQLException, Exception {
        if (!SeatCount.exists(seat_id)) {
            throw new Exception("Seat w/ this id don't exists");
        }
        if (!SeatCount.valid_seat(seat_id, ticket_id)) {
            throw new Exception("Seat w/ this id is not valid for this ticket");
        }
        if (!BoughtTicket.exists(ticket_id)) {
            throw new Exception("Ticket w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE bought_tickets SET seat_id=? WHERE bought_ticket_id=? ");){
            s.setInt(1, seat_id);
            s.setInt(2, ticket_id);
            s.executeUpdate();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

