/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import TS.FlightDijkstraFinder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class City {
    Integer city_id;
    String city_name;

    public Integer getCity_id() {
        return this.city_id;
    }

    public void setCity_id(Integer city_id) {
        this.city_id = city_id;
    }

    public String getCity_name() {
        return this.city_name;
    }

    public void setCity_name(String city_name) {
        this.city_name = city_name;
    }

    public String toString() {
        return "City{city_id=" + this.city_id + ", city_name=" + this.city_name + "}";
    }

    public static List<FlightDijkstraFinder.Zaznam> DirectCities(Integer from, Timestamp cas, Integer class_id) throws SQLException, Exception {
        if (!City.exists(from)) {
            throw new Exception("Flight w/ this id don't exists");
        }
        ArrayList<FlightDijkstraFinder.Zaznam> res = new ArrayList<FlightDijkstraFinder.Zaznam>();
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT arrival_time, a.city_id as arrival_city, flight_id FROM flights INNER JOIN airports as d ON flights.departure_airport_id=d.airport_id INNER JOIN airports as a ON flights.arrival_airport_id=a.airport_id WHERE d.city_id=? and departure_time>? and (select \"count\" from seat_count_in_class where seat_count_in_class.aircraft_type_id=flights.aircraft_type_id and class_id=?) > (SELECT count(*) from bought_tickets where bought_tickets.flight_id=flights.flight_id and class_id=?)");
        s.setInt(1, from);
        s.setTimestamp(2, cas);
        s.setInt(3, class_id);
        s.setInt(4, class_id);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            res.add(new FlightDijkstraFinder.Zaznam(rs.getInt("arrival_city"), rs.getTimestamp("arrival_time"), new ArrayList<Integer>(), rs.getInt("flight_id")));
        }
        return res;
    }

    public static boolean exists(int city_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from cities WHERE city_id=?");
        s.setInt(1, city_id);
        return s.executeQuery().next();
    }
}

