/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Flight {
    private Integer flight_id;
    private String name;
    private Timestamp departure_time;
    private Timestamp arrival_time;
    private Integer distance;
    private Integer departure_airport_id;
    private Integer arrival_airport_id;
    private Integer company_id;
    private Integer aircraft_id;
    private Integer flight_cost_id;

    public String toString() {
        return "Flights{flight_id=" + this.flight_id + ", name=" + this.name + ", departure_time=" + this.departure_time + ", arrival_time=" + this.arrival_time + ", distance=" + this.distance + ", departure_airport_id=" + this.departure_airport_id + ", arrival_airport_id=" + this.arrival_airport_id + ", company_id=" + this.company_id + ", aircraft_id=" + this.aircraft_id + ", flight_cost__id=" + this.flight_cost_id + "}";
    }

    public Integer getFlight_cost_id() {
        return this.flight_cost_id;
    }

    public void setFlight_cost_id(Integer flight_cost_id) {
        this.flight_cost_id = flight_cost_id;
    }

    public Integer getFlight_id() {
        return this.flight_id;
    }

    public void setFlight_id(Integer flight_id) {
        this.flight_id = flight_id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Timestamp getDeparture_time() {
        return this.departure_time;
    }

    public void setDeparture_time(Timestamp departure_time) {
        this.departure_time = departure_time;
    }

    public Timestamp getArrival_time() {
        return this.arrival_time;
    }

    public void setArrival_time(Timestamp arrival_time) {
        this.arrival_time = arrival_time;
    }

    public Integer getDistance() {
        return this.distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public Integer getDeparture_airport_id() {
        return this.departure_airport_id;
    }

    public void setDeparture_airport_id(Integer departure_airport_id) {
        this.departure_airport_id = departure_airport_id;
    }

    public Integer getArrival_airport_id() {
        return this.arrival_airport_id;
    }

    public void setArrival_airport_id(Integer arrival_airport_id) {
        this.arrival_airport_id = arrival_airport_id;
    }

    public Integer getCompany_id() {
        return this.company_id;
    }

    public void setCompany_id(Integer company_id) {
        this.company_id = company_id;
    }

    public Integer getAircraft_id() {
        return this.aircraft_id;
    }

    public void setAircraft_id(Integer aircraft_id) {
        this.aircraft_id = aircraft_id;
    }

    public void insert() throws SQLException, Exception {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO flights (flight_name, departure_time, arrival_time, distance, departure_airport_id, arrival_airport_id, company_id, aircraft_type_id, flight_cost_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);){
            s.setString(1, this.name);
            s.setTimestamp(2, this.departure_time);
            s.setTimestamp(3, this.arrival_time);
            s.setInt(4, this.distance);
            s.setInt(5, this.departure_airport_id);
            s.setInt(6, this.arrival_airport_id);
            s.setInt(7, this.company_id);
            s.setInt(8, this.aircraft_id);
            s.setInt(9, this.flight_cost_id);
            s.executeUpdate();
            try (ResultSet r = s.getGeneratedKeys();){
                r.next();
                this.flight_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (this.flight_id == null) {
            throw new IllegalStateException("flight_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE flights SET flight_name=?, departure_time=?, arrival_time=?, distance=?, departure_airport_id=?, arrival_airport_id=?, company_id=?, aircraft_type_id=?, flight_cost_id=?  WHERE flight_id=?");){
            s.setString(1, this.name);
            s.setTimestamp(2, this.departure_time);
            s.setTimestamp(3, this.arrival_time);
            s.setInt(4, this.distance);
            s.setInt(5, this.departure_airport_id);
            s.setInt(6, this.arrival_airport_id);
            s.setInt(7, this.company_id);
            s.setInt(8, this.aircraft_id);
            s.setInt(9, this.flight_cost_id);
            s.setInt(10, this.flight_id);
            s.executeUpdate();
        }
    }

    public static void updateAircraftType(int flight_id, int new_aircraft_type_id) throws SQLException, Exception {
        if (!Flight.exists(flight_id)) {
            throw new Exception("Flight w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE flights SET aircraft_type_id=? WHERE flight_id=?");){
            s.setInt(1, new_aircraft_type_id);
            s.setInt(2, flight_id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException, Exception {
        if (this.flight_id == null) {
            throw new IllegalStateException("flight_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM flights WHERE flight_id = ?");){
            s.setInt(1, this.flight_id);
            s.executeUpdate();
        }
    }

    public static boolean exists(int flight_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from flights WHERE flight_id=?");
        s.setInt(1, flight_id);
        return s.executeQuery().next();
    }
}

