/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.DbContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FlightCost {
    private Integer flight_cost_id;
    private Double price_per_km;

    public String toString() {
        return "FlightCosts{flight_cost_id=" + this.flight_cost_id + ", price_per_km=" + this.price_per_km + "}";
    }

    public Integer getFlight_cost_id() {
        return this.flight_cost_id;
    }

    public void setFlight_cost_id(Integer flight_cost_id) {
        this.flight_cost_id = flight_cost_id;
    }

    public Double getPrice_per_km() {
        return this.price_per_km;
    }

    public void setPrice_per_km(Double price_per_km) {
        this.price_per_km = price_per_km;
    }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO flight_costs (price_per_km) VALUES (?)", 1);){
            s.setDouble(1, this.price_per_km);
            s.executeUpdate();
            try (ResultSet r = s.getGeneratedKeys();){
                r.next();
                this.flight_cost_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (this.flight_cost_id == null) {
            throw new IllegalStateException("flight_cost_id is not set");
        }
        if (!FlightCost.exists(this.flight_cost_id)) {
            throw new Exception("Flight w/ this id don't exists ");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE flight_costs SET price_per_km=? WHERE flight_cost_id=?");){
            s.setDouble(1, this.price_per_km);
            s.setInt(2, this.flight_cost_id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (this.flight_cost_id == null) {
            throw new IllegalStateException("flight_cost_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM flight_costs WHERE flight_cost_id = ?");){
            s.setInt(1, this.flight_cost_id);
            s.executeUpdate();
        }
    }

    public static boolean exists(int flight_cost_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from flight_costs WHERE flight_cost_id=?");
        s.setInt(1, flight_cost_id);
        return s.executeQuery().next();
    }
}

