/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.Class;
import RDG.DbContext;
import RDG.Flight;
import RDG.PassengerType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlightsFinder {
    public static List<Flight> SelectAll() throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from flights ORDER BY flight_id");
        ResultSet rs = s.executeQuery();
        ArrayList<Flight> res = new ArrayList<Flight>();
        while (rs.next()) {
            Flight tmp = new Flight();
            tmp.setFlight_id(rs.getInt("flight_id"));
            tmp.setName(rs.getString("flight_name"));
            tmp.setDeparture_time(rs.getTimestamp("departure_time"));
            tmp.setArrival_time(rs.getTimestamp("arrival_time"));
            tmp.setDistance(rs.getInt("distance"));
            tmp.setAircraft_id(rs.getInt("aircraft_type_id"));
            tmp.setDeparture_airport_id(rs.getInt("departure_airport_id"));
            tmp.setArrival_airport_id(rs.getInt("arrival_airport_id"));
            tmp.setCompany_id(rs.getInt("company_id"));
            tmp.setFlight_cost_id(rs.getInt("flight_cost_id"));
            res.add(tmp);
        }
        return res;
    }

    public static Map<String, String> findByID(int id, int class_id, int passenger_type) throws SQLException, Exception {
        if (!Flight.exists(id)) {
            throw new Exception("Flight w/ this id don't exists");
        }
        if (!Class.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        if (!PassengerType.exists(passenger_type)) {
            throw new Exception("Passenger type w/ this id don't exists");
        }
        Float cena = Float.valueOf(0.0f);
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT *  from flights\nINNER JOIN airports as a ON a.airport_id=departure_airport_id INNER JOIN airports ON airports.airport_id=arrival_airport_id INNER JOIN companies ON companies.company_id = flights.company_id\nINNER JOIN aircraft_types ON aircraft_types.aircraft_type_id=flights.aircraft_type_id inner join cities on cities.city_id=airports.city_id inner join cities as c on c.city_id=a.city_id\ninner join flight_costs on flights.flight_cost_id=flight_costs.flight_cost_id \nCROSS JOIN  (SELECT (SELECT \"count\" from seat_count_in_class INNER JOIN flights ON flights.aircraft_type_id=seat_count_in_class.aircraft_type_id \nwhere flights.flight_id=? and seat_count_in_class.aircraft_type_id=flights.aircraft_type_id and seat_count_in_class.class_id=?) -\n(SELECT count(*) from bought_tickets where canceled=false and class_id=? and flight_id=?) as free) as free_seats \nwhere flights.flight_id=? and free>0");
        s.setInt(1, id);
        s.setInt(2, class_id);
        s.setInt(3, class_id);
        s.setInt(4, id);
        s.setInt(5, id);
        ResultSet rs = s.executeQuery();
        HashMap<String, String> ret = new HashMap<String, String>();
        while (rs.next()) {
            cena = Float.valueOf(rs.getFloat("price_per_km") * (float)rs.getInt("distance"));
            PreparedStatement ps = DbContext.getConnection().prepareStatement("SELECT * from classes inner join flight_costs on flight_costs.flight_cost_id=classes.flight_cost_id and class_id=?");
            ps.setInt(1, class_id);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                cena = Float.valueOf(cena.floatValue() + res.getFloat("price_per_km") * (float)rs.getInt("distance"));
            }
            ps = DbContext.getConnection().prepareStatement("SELECT * from passenger_types inner join flight_costs on flight_costs.flight_cost_id=passenger_types.flight_cost_id and passenger_type_id=?");
            ps.setInt(1, passenger_type);
            res = ps.executeQuery();
            while (res.next()) {
                cena = Float.valueOf(cena.floatValue() + res.getFloat("price_per_km") * (float)rs.getInt("distance"));
            }
            ret.put("flight_id", rs.getString("flight_id"));
            ret.put("flight_name", rs.getString("flight_name"));
            ret.put("departure_time", rs.getString("departure_time"));
            ret.put("arrival_time", rs.getString("arrival_time"));
            ret.put("distance", rs.getString("distance"));
            ret.put("name", rs.getString("name"));
            ret.put("aircraft_name", rs.getString("aircraft_name"));
            ret.put("departure_airport", rs.getString(13));
            ret.put("departure_city", rs.getString(28));
            ret.put("arrival_airport", rs.getString(18));
            ret.put("arrival_city", rs.getString(26));
            ret.put("price_per_km", rs.getString("price_per_km"));
            ret.put("distance", rs.getString("distance"));
            ret.put("cena", cena.toString());
            ret.put("free", rs.getString("free"));
        }
        return ret;
    }
}

