/*
 * Decompiled with CFR 0.152.
 */
package RDG;

import RDG.AircraftType;
import RDG.BoughtTicket;
import RDG.Class;
import RDG.DbContext;
import RDG.Flight;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SeatCount {
    private int aircraft_type_id;
    private int count;
    private int class_id;

    public int getAircraft_type_id() {
        return this.aircraft_type_id;
    }

    public void setAircraft_type_id(int aircraft_type_id) {
        this.aircraft_type_id = aircraft_type_id;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getClass_id() {
        return this.class_id;
    }

    public void setClass_id(int class_id) {
        this.class_id = class_id;
    }

    public void delete() throws SQLException {
        PreparedStatement t = DbContext.getConnection().prepareStatement("DELETE FROM seat_count_in_class WHERE aircraft_type_id=?");
        t.setInt(1, this.aircraft_type_id);
        t.executeUpdate();
        t = DbContext.getConnection().prepareStatement("DELETE FROM seats WHERE aircraft_type_id=?");
        t.setInt(1, this.aircraft_type_id);
        t.executeUpdate();
    }

    public void insert() throws SQLException, Exception {
        PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO seat_count_in_class (\"count\", aircraft_type_id, class_id) VALUES (?, ?, ?);");
        s.setInt(1, this.count);
        s.setInt(2, this.aircraft_type_id);
        s.setInt(3, this.class_id);
        s.executeUpdate();
        for (int j = 0; j < this.count; ++j) {
            PreparedStatement ps = DbContext.getConnection().prepareStatement("INSERT INTO seats (aircraft_type_id, class_id, seat_number) VALUES (?, ?, ?);");
            ps.setInt(1, this.aircraft_type_id);
            ps.setInt(2, this.class_id);
            ps.setInt(3, j);
            ps.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean seatExists(Integer ticket_id) {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT EXISTS(SELECT * FROM bought_tickets WHERE canceled=false AND bought_ticket_id=? AND seat_id IS NOT NULL) as b");){
            s.setInt(1, ticket_id);
            ResultSet rs = s.executeQuery();
            if (!rs.next()) return false;
            boolean bl = rs.getBoolean("b");
            return bl;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return false;
    }

    public static Map<String, String> selectFree(Integer class_id, Integer aircraft_id, Integer flight_id) throws SQLException, Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        if (!Class.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        if (!AircraftType.exists(aircraft_id)) {
            throw new Exception("Aircraft w/ this id don't exists");
        }
        if (!Flight.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM seats WHERE NOT EXISTS(SELECT * FROM bought_tickets WHERE bought_tickets.seat_id=seats.seat_id AND bought_tickets.flight_id=? AND canceled=false)AND class_id=? AND aircraft_type_id=?");){
            s.setInt(1, flight_id);
            s.setInt(2, class_id);
            s.setInt(3, aircraft_id);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                res.put(rs.getString("seat_id"), rs.getString("seat_number"));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countBooked(Integer class_id, Integer aircraft_id, Integer flight_id) throws SQLException, Exception {
        if (!Class.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        if (!AircraftType.exists(aircraft_id)) {
            throw new Exception("Aircraft w/ this id don't exists");
        }
        if (!Flight.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT count(*) FROM bought_tickets WHERE flight_id=? AND class_id=? AND canceled=false");){
            s.setInt(1, class_id);
            s.setInt(2, flight_id);
            ResultSet rs = s.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return 0;
    }

    public static boolean exists(int seat_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from seats WHERE seat_id=?");
        s.setInt(1, seat_id);
        return s.executeQuery().next();
    }

    public static boolean valid_seat(int seat_id, int ticket_id) throws SQLException, Exception {
        BoughtTicket b = new BoughtTicket();
        b.findById(ticket_id);
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM seats WHERE NOT EXISTS(SELECT * FROM bought_tickets WHERE bought_tickets.seat_id=seats.seat_id AND bought_tickets.flight_id=? AND canceled=false)AND class_id=? AND aircraft_type_id=? AND seat_id=?");
        s.setInt(1, b.getFlight_id());
        s.setInt(2, b.getClass_id());
        s.setInt(3, b.getAircraft_type_id());
        s.setInt(4, seat_id);
        return s.executeQuery().next();
    }

    public static void changeBookedSeats(int new_aircrcaft_id, int flight_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE bought_tickets SET seat_id=random_nonbooked_seat_from_aircraft(?, ?, bought_ticket_id) WHERE flight_id=?");
        s.setInt(1, flight_id);
        s.setInt(2, new_aircrcaft_id);
        s.setInt(3, flight_id);
        s.executeUpdate();
    }
}

