/*
 * Decompiled with CFR 0.152.
 */
package TS;

import RDG.City;
import RDG.Class;
import RDG.FlightsFinder;
import RDG.PassengerType;
import RDG.Searchings;
import RDG.UsersDB;
import UI.BuyTicket;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class FlightDijkstraFinder {
    public static void Dijkstra(Integer departure_id, Integer arrival_id, Timestamp departure_time, Integer class_id, Integer passenger_type, Integer user_id) throws SQLException, IOException, Exception {
        if (!City.exists(departure_id)) {
            throw new Exception("Departure city w/ this id don't exists");
        }
        if (!City.exists(arrival_id)) {
            throw new Exception("Arrival city w/ this id don't exists");
        }
        if (!Class.exists(class_id)) {
            throw new Exception("Class w/ this id don't exists");
        }
        if (!PassengerType.exists(passenger_type)) {
            throw new Exception("Passenger type w/ this id don't exists");
        }
        if (!UsersDB.exists(user_id)) {
            throw new Exception("User w/ this id don't exists");
        }
        HashMap<Integer, List<Integer>> dist = new HashMap<Integer, List<Integer>>();
        PriorityQueue<Zaznam> pq = new PriorityQueue<Zaznam>();
        pq.add(new Zaznam(departure_id, departure_time, new ArrayList<Integer>(), null));
        while (!pq.isEmpty()) {
            Zaznam top = (Zaznam)pq.poll();
            while (!pq.isEmpty() && dist.containsKey(top.i)) {
                top = (Zaznam)pq.poll();
            }
            if (dist.containsKey(top.i)) break;
            dist.put(top.i, top.flight_list);
            if (top.flight_list.size() > 5 || top.i.equals(arrival_id)) break;
            for (Zaznam p : City.DirectCities(top.i, top.cas, class_id)) {
                ArrayList<Integer> tmp_flight_list = new ArrayList<Integer>();
                tmp_flight_list.addAll(top.flight_list);
                tmp_flight_list.add(p.flight_id);
                pq.add(new Zaznam(p.i, p.cas, tmp_flight_list, p.flight_id));
            }
        }
        System.out.println(dist.get(arrival_id));
        if (dist.get(arrival_id) == null) {
            System.out.println("Nena\u0161iel som \u017eiadne lety");
            return;
        }
        System.out.println("Je tu tak\u00e1to mo\u017enos\u0165:");
        List res = (List)dist.get(arrival_id);
        Float cena = Float.valueOf(0.0f);
        System.out.println("\tID\tFlight\tDeparture time \t\t\tArrival time \t\t\tdist \tcompany \t\t\t\taircraft \t\t\t\tdeparture airport \tdeparture city \t\t\tarrival airport \tarr. city\t\t\tCost\tFree seats");
        for (int j = 0; j < res.size(); ++j) {
            System.out.print("\t");
            Map<String, String> let = FlightsFinder.findByID((Integer)res.get(j), class_id, passenger_type);
            cena = Float.valueOf(cena.floatValue() + Float.valueOf(let.get("cena")).floatValue());
            String str = "                                   ";
            System.out.println(let.get("flight_id") + "\t" + let.get("flight_name") + "\t" + let.get("departure_time") + "\t" + let.get("arrival_time") + "\t" + let.get("distance") + "\t" + let.get("name") + str.substring(let.get("name").length()) + "\t" + let.get("aircraft_name") + str.substring(let.get("aircraft_name").length() + 3) + "\t" + let.get("departure_airport") + "\t" + let.get("departure_city") + str.substring(let.get("departure_city").length() + 10) + "\t" + let.get("arrival_airport") + "\t" + let.get("arrival_city") + str.substring(let.get("arrival_city").length() + 10) + "\t" + cena.toString() + "\t" + let.get("free"));
        }
        System.out.printf("Cena za tuto moznost normalna: %f\n", cena);
        System.out.printf("Cena za tuto moznost po zapocitani hladania: %f\n", (double)cena.floatValue() + (double)cena.floatValue() * Math.sqrt(Searchings.num(departure_id, arrival_id, user_id).intValue()));
        System.out.println("Chce\u0161 si rovno k\u00fapi\u0165 l\u00edstok? 0/1");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        if (input.readLine().equals("1")) {
            BuyTicket.Buy(res, class_id, passenger_type);
        }
    }

    public static class Zaznam
    implements Comparable {
        public Timestamp cas;
        public Integer i;
        public Integer flight_id;
        public List<Integer> flight_list;

        public Zaznam(Integer i, Timestamp cas, List<Integer> l, Integer flight_id) {
            this.cas = cas;
            this.i = i;
            this.flight_list = l;
            this.flight_id = flight_id;
        }

        public int compareTo(Object o) {
            return this.cas.compareTo(((Zaznam)o).cas);
        }
    }
}

