package RDG;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

/**
 *
 * @author Marcel
 */

/**
* Data row class for aircraft_types table
*/
public class AircraftType {
    private Integer aircraft_type_id;
    private String aircraft_name;

    public Integer getAircraft_type_id() {
        return aircraft_type_id;
    }

    public void setAircraft_type_id(Integer aircraft_type_id) {
        this.aircraft_type_id = aircraft_type_id;
    }

    public String getAircraft_name() {
        return aircraft_name;
    }

    public void setAircraft_name(String name) {
        this.aircraft_name = name;
    }

    @Override
    public String toString() {
        return "AircraftTypes{" + "aircraft_id=" + aircraft_type_id + ", aircraft_name=" + aircraft_name + '}';
    }
    
    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO aircraft_types (aircraft_name) VALUES (?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, aircraft_name);
            
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                aircraft_type_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (aircraft_type_id == null) {
            throw new IllegalStateException("aircraft_type_id is not set");
        }
        
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE aircraft_types SET aircraft_name=? WHERE aircraft_type_id=?")) {
            s.setString(1, aircraft_name);
            s.setInt(2, aircraft_type_id); 

            s.executeUpdate();
        }
    }

    public void delete() throws SQLException, Exception {
        if (aircraft_type_id == null) {
            throw new IllegalStateException("aircraft_type_id is not set");
        }
        
        SeatCount sdb = new SeatCount();
        sdb.setAircraft_type_id(aircraft_type_id);
        sdb.delete();
        
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM aircraft_types WHERE aircraft_type_id = ?")) {
            s.setInt(1, aircraft_type_id);

            s.executeUpdate();
        }
    }
    /**
    * if new aircraft don't have enough seats throw Exception
    * @param new_aircraft new aircraft_id
    * @param flight_id flight_id where you want to replace aircraft
    * @throws SQLException
    * @throws Exception
    */
    static public void canReplaceAirplane(Integer new_aircraft, Integer flight_id) throws SQLException, Exception{
        if(!AircraftType.exists((int)new_aircraft))
            throw new Exception("Aircraft w/ this id don't exists");
        if(!Flight.exists(flight_id))
            throw new Exception("Flight w/ this id don't exists");
        
        Integer old_aircraft_id=null;
        PreparedStatement s=DbContext.getConnection().prepareStatement("SELECT aircraft_on_flight(?)");
        s.setInt(1,flight_id);
        ResultSet rs = s.executeQuery();
        while(rs.next()){
            old_aircraft_id=rs.getInt(1);
        }
        if(old_aircraft_id==null)
            throw new Exception("Cannot find aircraft on this flight");
        
        s=DbContext.getConnection().prepareStatement("SELECT * FROM seat_count_in_class WHERE aircraft_type_id=?");
        s.setInt(1,old_aircraft_id);
        rs = s.executeQuery();
        while(rs.next()){
            PreparedStatement ps = DbContext.getConnection().prepareStatement("SELECT * FROM seat_count_in_class WHERE aircraft_type_id=? AND class_id=?");
            ps.setInt(1,new_aircraft);
            ps.setInt(2,rs.getInt("class_id"));
            ResultSet res_set = ps.executeQuery();
            while(res_set.next()){
                if(res_set.getInt("count")<SeatCount.countBooked(rs.getInt("class_id"), old_aircraft_id, flight_id))
                    throw new Exception("Nové lietadlo nemá dosť miest nejakej triede");
            }
        }
    }
    /**
     * check if aircraft_type w/ this id exists
     * @param aircraft_type_id  
     * @throws SQLException
     * @return boolean if aircraft w/ this id exists
     */
    public static boolean exists(int aircraft_type_id) throws SQLException{
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from aircraft_types WHERE aircraft_type_id=?");
        s.setInt(1, aircraft_type_id);
        return s.executeQuery().next();
    }
}
