package RDG;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Marcel
 */
public class AircraftTypeFinder {
    /**
    * select all aircraft_types
    * @throws SQLException
    * @return List of AircraftTypes
    */
    static public List<AircraftType> selectAll() throws SQLException{
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from aircraft_types");
        List<AircraftType> res = new ArrayList<>();
        ResultSet rs = s.executeQuery();
        while(rs.next()){
            AircraftType tmp = new AircraftType();
            tmp.setAircraft_type_id(rs.getInt("aircraft_type_id"));
            tmp.setAircraft_name(rs.getString("aircraft_name"));
            res.add(tmp);
        }
        return res;
    }
    /**
     * selectById aircraft by id
     * @param aircraft_type_id   
     * @throws SQLException
     * @return city
     */
    public static AircraftType selectById(Integer aircraft_type_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from aircraft_types WHERE aircraft_type_id=?");
        s.setInt(1,aircraft_type_id);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            AircraftType tmp = new AircraftType();
            tmp.setAircraft_type_id(rs.getInt("aircraft_type_id"));
            tmp.setAircraft_name(rs.getString("aircraft_name"));
            return tmp;
        }
        return null;
    }
}
