package RDG;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
/**
 *
 * @author Marcel
 */

/**
* data row gateway for airports
*/
public class Airport {
    private Integer airport_id;
    private String full_name;
    private String icao_code;
    private String iata_code;
    private Integer city_id;


    @Override
    public String toString() {
        return "Airports{" + "airport_id=" + airport_id + ", full_name=" + full_name + ", icao_code=" + icao_code + ", iata_code=" + iata_code + ", city_id=" + city_id + '}';
    }

    public Integer getAirport_id() {
        return airport_id;
    }

    public void setAirport_id(Integer airport_id) {
        this.airport_id = airport_id;
    }
    
    public String getFull_name() {
        return full_name;
    }

    public void setFull_name(String full_name) {
        this.full_name = full_name;
    }

    public String getIcao_code() {
        return icao_code;
    }

    public void setIcao_code(String icao_code) {
        this.icao_code = icao_code;
    }

    public String getIata_code() {
        return iata_code;
    }

    public void setIata_code(String iata_code) {
        this.iata_code = iata_code;
    }

    public Integer getCity_id() {
        return city_id;
    }

    public void setCity_id(Integer city_id) {
        this.city_id = city_id;
    }
    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO airports (full_name, icao_code, iata_code, city_id) VALUES (?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, full_name);
            s.setString(2, icao_code);
            s.setString(3, iata_code);
            s.setInt(4, city_id);

            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                airport_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        
        if (airport_id == null) {
            throw new IllegalStateException("airport_id is not set");
        }
        
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE airports SET full_name = ?, icao_code = ?, iata_code = ?, city_id = ? WHERE airport_id = ?")) {
            s.setString(1, full_name);
            s.setString(2, icao_code);
            s.setString(3, iata_code);
            s.setInt(4, city_id);
            s.setInt(5, airport_id);

            s.executeUpdate();
        }
    }

    public void delete() throws SQLException, Exception {
        if (airport_id == null) {
            throw new IllegalStateException("airport_id is not set");
        }
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM airports WHERE airport_id = ?")) {
            s.setInt(1, airport_id);

            s.executeUpdate();
        }
    }
    /**
     * check if airports w/ this id exists
     * @param airport_id  
     * @throws SQLException
     * @return boolean if airport w/ this id exists
     */
    public static boolean exists(int airport_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from airports WHERE airport_id=?");
        s.setInt(1, airport_id);
        return s.executeQuery().next();
    }
}
