package RDG;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.sql.SQLException;

/**
 *
 * @author Marcel
 */
public class AirportFinder {

    /**
     * select all airports
     * @return List of Airport
     * @throws SQLException
     */
    public static List<Airport> SelectAll() throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from airports inner join cities on cities.city_id=airports.city_id order by airport_id");
        //System.out.println(s);
        ResultSet rs = s.executeQuery();
        List<Airport> res = new ArrayList<>();
        while (rs.next()) {
            Airport tmp = new Airport();
            tmp.setAirport_id(rs.getInt("airport_id"));
            tmp.setCity_id(rs.getInt("city_id"));
            tmp.setFull_name(rs.getString("full_name"));
            tmp.setIata_code(rs.getString("iata_code"));
            tmp.setIcao_code(rs.getString("icao_code"));
            res.add(tmp);
        }
        return res;
    }
    /**
     * selectById airport by id
     * @param airport_id  
     * @throws SQLException
     * @return city
     */
    public static Airport selectById(Integer airport_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from airports WHERE airport_id=?");
        s.setInt(1,airport_id);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            Airport tmp = new Airport();
            tmp.setAirport_id(rs.getInt("airport_id"));
            tmp.setCity_id(rs.getInt("city_id"));
            tmp.setFull_name(rs.getString("full_name"));
            tmp.setIata_code(rs.getString("iata_code"));
            tmp.setIcao_code(rs.getString("icao_code"));
            return tmp;
        }
        return null;
    }
}
