package RDG;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.sql.SQLException;

/**
 *
 * @author Marcel
 */
public class BoughtTicketsFinder {

    /**
     * Return all bought tickets for some flight
     * @param flight_id flight for which should be tickets find
     * @return List of BoughtTicket
     * @throws SQLException
     */
    public static List<BoughtTicket> selectAll(int flight_id) throws SQLException, Exception {
        if(!RDG.Flight.exists(flight_id))
            throw new Exception("Flight w/ this id don't exists");
        List<BoughtTicket> res = new ArrayList<>();
        try (final PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT bought_ticket_id, flights.flight_id, class_id, passenger_id, aircraft_type_id, seat_id, canceled "
                + "FROM bought_tickets INNER JOIN flights ON flights.flight_id= bought_tickets.flight_id WHERE flights.flight_id=?")) {
            s.setInt(1, flight_id);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                BoughtTicket tmp = new BoughtTicket();
                tmp.setBought_ticket_id(rs.getInt("bought_ticket_id"));
                tmp.setFlight_id(rs.getInt("flight_id"));
                tmp.setClass_id(rs.getInt("class_id"));
                tmp.setPassenger_id(rs.getInt("passenger_id"));
                tmp.setAircraft_type_id(rs.getInt("aircraft_type_id"));
                tmp.setSeat_id(rs.getInt("seat_id"));
                tmp.setCanceled(rs.getBoolean("canceled"));
                res.add(tmp);
            }
        } catch (Exception e) {
            System.out.println(e);
        }
        return res;
    }
    
}
