package RDG;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.sql.SQLException;

/**
 *
 * @author Marcel
 */
public class CitiesFinder {

    /**
     * selectById all cities
     * @throws SQLException
     * @return List of City
     */
    public static List<City> selectAll() throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from cities");
        ResultSet rs = s.executeQuery();
        List<City> res = new ArrayList<>();
        while (rs.next()) {
            City tmp = new City();
            tmp.setCity_id(rs.getInt("city_id"));
            tmp.setCity_name(rs.getString("city_name"));
            res.add(tmp);
        }
        return res;
    }
    
    /**
     * selectById city by id
     * @param city_id 
     * @throws SQLException
     * @return city
     */
    public static City selectById(Integer city_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from cities WHERE city_id=?");
        s.setInt(1,city_id);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            City tmp = new City();
            tmp.setCity_id(rs.getInt("city_id"));
            tmp.setCity_name(rs.getString("city_name"));
            return tmp;
        }
        return null;
    }
    
}
