package RDG;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

/**
 *
 * @author Marcel
 */

 /**
* data row gateway for flight costs
*/
public class FlightCost {
    private Integer flight_cost_id;
    private Double price_per_km;

    @Override
    public String toString() {
        return "FlightCosts{" + "flight_cost_id=" + flight_cost_id + ", price_per_km=" + price_per_km + '}';
    }
    
    public Integer getFlight_cost_id() {
        return flight_cost_id;
    }

    public void setFlight_cost_id(Integer flight_cost_id) {
        this.flight_cost_id = flight_cost_id;
    }

    public Double getPrice_per_km() {
        return price_per_km;
    }

    public void setPrice_per_km(Double price_per_km) {
        this.price_per_km = price_per_km;
    }
    
    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO flight_costs (price_per_km) VALUES (?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setDouble(1, price_per_km);
            
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                flight_cost_id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException, Exception {
        if (flight_cost_id == null) {
            throw new IllegalStateException("flight_cost_id is not set");
        }
        if(!FlightCost.exists(flight_cost_id))
            throw new Exception("Flight w/ this id don't exists ");
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE flight_costs SET price_per_km=? WHERE flight_cost_id=?")) {
            s.setDouble(1, price_per_km);
            s.setInt(2, flight_cost_id);

            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (flight_cost_id == null) {
            throw new IllegalStateException("flight_cost_id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM flight_costs WHERE flight_cost_id = ?")) {
            s.setInt(1, flight_cost_id);

            s.executeUpdate();
        }
    }
    /**
     * check if flight_cost w/ this id exists
     * @param flight_cost_id 
     * @throws SQLException
     * @return boolean if flight_cost w/ this id exists
     */
    public static boolean exists(int flight_cost_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from flight_costs WHERE flight_cost_id=?");
        s.setInt(1, flight_cost_id);
        return s.executeQuery().next();
    }
}
