package RDG;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Marcel
 */
public class Passenger {
    Integer passenger_id;
    String passenger_id_card, passenger_name;

    public Integer getPassenger_id() {
        return passenger_id;
    }

    public void setPassenger_id(Integer passenger_id) {
        this.passenger_id = passenger_id;
    }

    public String getPassenger_id_card() {
        return passenger_id_card;
    }

    public void setPassenger_id_card(String passenger_id_card) {
        this.passenger_id_card = passenger_id_card;
    }

    public String getPassenger_name() {
        return passenger_name;
    }

    public void setPassenger_name(String passenger_name) {
        this.passenger_name = passenger_name;
    }

    @Override
    public String toString() {
        return "Passenger{" + "passenger_id=" + passenger_id + ", passenger_id_card=" + passenger_id_card + ", passenger_name=" + passenger_name + '}';
    }
    
    /**
    * insert into passengers table
    * @param name passenger name
    * @param id_card passenger id card
    * @throws SQLException
    */
    public static int insert(String name, String id_card) throws SQLException{
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO passengers (passenger_name, passenger_id_card) VALUES (?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, name);
            s.setString(2, id_card);

            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                return r.getInt(1);
            }
        }
    }
    /**
    * check if passenger w/ this id exists
    * @param passenger_id
    * @throws SQLException
    * @return boolean if passenger exists
    */
    public static boolean exists(int passenger_id) throws SQLException {
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from passengers WHERE passenger_id=?");
        s.setInt(1, passenger_id);
        return s.executeQuery().next();
    }
}
