package RDG;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.sql.SQLException;

/**
 *
 * @author Marcel
 */
public class PassengerFinder {

    /**
     * selectAll all passengers
     * @param prefix prefix of passenger name to find 
     * @return List of Maps where keys are column names related to passengers
     */
    public static List<Passenger> selectWithPrefix(String prefix) throws SQLException {
        List<Passenger> res = new ArrayList<>();
        PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * from passengers WHERE substring(passenger_name from 1 for 2)=? LIMIT 1000");
        s.setString(1, prefix);
        ResultSet rs = s.executeQuery();
        while (rs.next()) {
            Passenger tmp = new Passenger();
            tmp.setPassenger_id(rs.getInt("passenger_id"));
            tmp.setPassenger_id_card(rs.getString("passenger_id_card"));
            tmp.setPassenger_name(rs.getString("passenger_name"));
            res.add(tmp);
        }
        return res;
    }
    
}
