package TS;

import RDG.BoughtTicket;
import java.sql.SQLException;

/**
 *
 * @author Marcel
 */
public class TicketCancelTS {
    /**
     * cancel ticket
     * isolation level: read commited
     * - cancel ticket
     * @param ticket_id to which ticket
     * @throws SQLException
     * @throws Exception
     * @return boolean if everything went right 
     */
    public static boolean transactionTicketCancel(Integer ticket_id) throws SQLException, Exception{
        RDG.DbContext.getConnection().setAutoCommit(false);
        
        RDG.DbContext.getConnection().setTransactionIsolation(java.sql.Connection.TRANSACTION_READ_COMMITTED);
        
        boolean podarilo = false;
        Exception t=null;
        for(int i=0;i<3 && !podarilo;i++){
            podarilo=true;
            try{
                BoughtTicket.cancel(ticket_id);
            }catch(Exception e){
                t=e;
                RDG.DbContext.getConnection().rollback();
                podarilo=false;
            }
        }
        if(podarilo){
            RDG.DbContext.getConnection().commit();
            RDG.DbContext.getConnection().setAutoCommit(true);
            return true;
        }
        System.err.println(t);
        RDG.DbContext.getConnection().rollback();
        RDG.DbContext.getConnection().setAutoCommit(true);
        return false;
    }
}
