package UI;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import RDG.*;

/**
 *
 * @author Marcel
 */
public class AircraftMenu {
    /**
    * Print Aircraft menu
    * @throws IOException
    */
    public static void AircraftsMenu() throws IOException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while(true){
            System.out.println("Lietadlá. Možnosti:");
            System.out.println("1 - Zobraz lietadlá");
            System.out.println("2 - Pridaj lietadlo");
            System.out.println("3 - Aktualizuj lietadlo");
            System.out.println("4 - Odstráň lietadlo");
            System.out.println("5 - return");
            String odpoved = input.readLine();
            
            try{
                switch(odpoved){
                    case "1" -> printAircrafts();
                    case "2" -> AddAircraftType();
                    case "3" -> UpdateAircraftType();
                    case "4" -> DeleteAircraftType();
                    case "5" -> { return; }
                    default -> System.out.println("Skús ešte raz");
                }
            } catch(SQLException e){
                throw new RuntimeException(e);
            }   
        }
    }
    /**
    * Print all aircraft types
    * @throws SQLException
    */
    public static void printAircrafts() throws SQLException{
        List<AircraftType> res = AircraftTypeFinder.selectAll();
        BatchOutput.BatchPrint(res);
    }
    /**
    * Add aircraft type
    * @throws SQLException
    * @throws IOException
    */
    public static void AddAircraftType() throws IOException, SQLException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        AircraftType at = new AircraftType();
        
        try{
            System.out.println("Názov lietadla:");
            at.setAircraft_name(input.readLine());
            at.insert();
            System.out.println("Počet tried:");
            int n=Integer.valueOf(input.readLine());
            
            AddSeatsToClass(n, at);
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        System.out.println("Lietadlo bolo úspešne pridané");
        System.out.print("ID: ");
        System.out.println(at.getAircraft_type_id());
    }
    /**
    * Update aircraft type
    * @throws SQLException
    */
    public static void UpdateAircraftType() throws SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        AircraftType at = new AircraftType();
        
        try{
            System.out.println("Id lietadla:");
            at.setAircraft_type_id(Integer.valueOf(input.readLine()));
            System.out.println("Názov lietadla:");
            at.setAircraft_name(input.readLine());
            System.out.println("Počet tried:");
            int n=Integer.valueOf(input.readLine());
            
            SeatCount sc = new SeatCount();
            sc.setAircraft_type_id(at.getAircraft_type_id());
            sc.delete();
            
            AddSeatsToClass(n, at);
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        at.update();
        
        System.out.println("Lietadlo bolo úspešne updatované");
    }
    /**
    * Delete aircraft type
    * @throws SQLException
    */
    public static void DeleteAircraftType() throws SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        AircraftType at = new AircraftType();
        
        try{
            System.out.println("Id lietadla:");
            at.setAircraft_type_id(Integer.valueOf(input.readLine()));
         } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        at.delete();
        SeatCount sc = new SeatCount();
        sc.setAircraft_type_id(at.getAircraft_type_id());
        sc.delete();
        
        System.out.println("Lietadlo bolo úspešne zmazané");
    }
    /**
    * Add seats into classes to aircraft type
    * @param n class count
    * @param at aircraft type where add seats
    * @throws IOException
    * @throws SQLException
    * @throws Exception
    */
    public static void AddSeatsToClass(int n, AircraftType at) throws SQLException, IOException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        SeatCount sc = new SeatCount();
        
        for(int i=0;i<n;i++){
            Classes.print();
            System.out.printf("Zadaj id %d. triedy:\n", i+1);
            int class_id = Integer.valueOf(input.readLine());
            System.out.printf("Zadaj pocet sedadiel %d. triedy:\n", i+1);
            int seat_count = Integer.valueOf(input.readLine());

            sc.setAircraft_type_id(at.getAircraft_type_id());
            sc.setClass_id(class_id);
            sc.setCount(seat_count);
            sc.insert();
        }
    }
    
}
