package UI;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import RDG.*;

/**
 *
 * @author Marcel
 */
public class AirportsMenu {
    /**
    * printAirports airports menu
    * @throws IOException
    */
    public static void AirportsMenu() throws IOException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while(true){
            System.out.println("Letiská. Možnosti:");
            System.out.println("1 - Zobraz letiská");
            System.out.println("2 - Pridaj letisko");
            System.out.println("3 - Aktualizuj letisko");
            System.out.println("4 - Odstráň letisko");
            System.out.println("5 - return");
            String odpoved = input.readLine();
            
            try{
                switch(odpoved){
                    case "1" -> printAirports();
                    case "2" -> AddAirport();
                    case "3" -> UpdateAirport();
                    case "4" -> DeleteAirport();
                    case "5" -> { return; }
                    default -> System.out.println("Skús ešte raz");
                }
            } catch(SQLException e){
                throw new RuntimeException(e);
            }   
        }
    }
    /**
    * printAirports all airports
    * @throws SQLException
    */
    public static void printAirports() throws SQLException{
        List<Airport> res = AirportFinder.SelectAll();
        BatchOutput.BatchPrint(res);
    }
    /**
    * printAirports menu for adding airport
    * @throws SQLException
    */
    public static void AddAirport() throws SQLException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Airport a = new Airport();
        try{
            System.out.println("Meno:");
            a.setFull_name(input.readLine());
            System.out.println("ICAO:");
            a.setIcao_code(input.readLine());
            System.out.println("IATA");
            a.setIata_code(input.readLine());
            Cities.printCities();
            System.out.println("Mesto (id):");
            a.setCity_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        a.insert();

        System.out.println("Letisko úspešne pridané");
        System.out.print("ID: ");
        System.out.println(a.getAirport_id());
    }
    /**
    * printAirports update airport menu
    * @throws SQLException
    * @throws Exception
    */
    public static void UpdateAirport() throws SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Airport a = new Airport();
        try{
            System.out.println("Airport (id):");
            a.setAirport_id(Integer.valueOf(input.readLine()));
            System.out.println("Meno:");
            a.setFull_name(input.readLine());
            System.out.println("ICAO:");
            a.setIcao_code(input.readLine());
            System.out.println("IATA");
            a.setIata_code(input.readLine());
            Cities.printCities();
            System.out.println("Mesto (id):");
            a.setCity_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        a.update();

        System.out.println("Letisko úspešne updatované");
    }
    /**
    * printAirports delete airport menu
    * @throws SQLException
    */
    public static void DeleteAirport() throws SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Airport a = new Airport();
        try{
            System.out.println("Airport (id):");
            a.setAirport_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        a.delete();

        System.out.println("Letisko úspešne vymazané");
    }
    
}
