package UI;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import RDG.*;

/**
 *
 * @author Marcel
 */
public class FlightCostsMenu {
    /**
    * Print Flight cost menu
    * @throws IOException
    */ 
    public static void FlightCostsMenu() throws IOException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while(true){
            System.out.println("Cenové tarify. Možnosti:");
            System.out.println("1 - Zobraz cenové tarify");
            System.out.println("2 - Pridaj cenovú tarifu");
            System.out.println("3 - Aktualizuj cenovú tarifu");
            System.out.println("4 - Odstráň cenovú tarifu");
            System.out.println("5 - return");
            String odpoved = input.readLine();
            
            try{
                switch(odpoved){
                    case "1" -> print();
                    case "2" -> AddFlightCost();
                    case "3" -> UpdateFlightCost();
                    case "4" -> DeleteFlightCost();
                    case "5" -> { return; }
                    default -> System.out.println("Skús ešte raz");
                }
            } catch(SQLException e){
                System.out.println(e);
            }   
        }
    }
    /**
    * Print all flight costs constants
    * @throws SQLException
    */
    public static void print() throws SQLException{
        var res = FlightCostFinder.SelectAll();
        BatchOutput.BatchPrint(res);
    }
    /**
    * Add Flight cost constant
    * @throws SQLException
    */
    public static void AddFlightCost() throws SQLException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        FlightCost f = new FlightCost();
        try{
            System.out.println("Cena za km:");
            f.setPrice_per_km(Double.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        f.insert();
       
        System.out.println("Tarifa úspešne pridaná");
    }
    /**
    * Update flight costs constants
    * @throws SQLException
    */
    public static void UpdateFlightCost() throws SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        FlightCost f = new FlightCost();
        try{
            System.out.println("Cenova tarifa (id):");
            f.setFlight_cost_id(Integer.valueOf(input.readLine()));
            System.out.println("Cena za km:");
            f.setPrice_per_km(Double.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        f.update();
       
        System.out.println("Tarifa bola úspešne updatovaná");
        System.out.print("ID: ");
        System.out.println(f.getFlight_cost_id());
    }
    /**
    * Delete flight costs constants
    * @throws SQLException
    */
    public static void DeleteFlightCost() throws SQLException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        FlightCost f = new FlightCost();
        try{
            System.out.println("Cenova tarifa (id):");
            f.setFlight_cost_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        f.delete();
        System.out.println("Tarifa bola úspešne vymazaná");
    }
    
    
}
