package UI;

import TS.FlightDijkstraFinder;
import RDG.FlightsFinder;
import RDG.Searchings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

/**
 *
 * @author Marcel
 */
public class FlightsFinderMenu {
    /**
    * prints flights finder menu
    * @throws SQLException
    * @throws IOException
    * @throws Exception
    */
    static public void Menu() throws IOException, SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        Integer departure_id, arrival_id, one_way, class_id, passenger_type, user_id;
        Timestamp departure_time, arrival_time=null;
        try{
            System.out.println("Ok, ideme hľadať let.");
            UI.Cities.printCities();
            System.out.println("ID mesta odletu:");
            departure_id = Integer.valueOf(input.readLine());
            System.out.println("ID mesta príletu:");
            arrival_id = Integer.valueOf(input.readLine());
            System.out.println("Cas odletu:");
            departure_time = Timestamp.valueOf(input.readLine());
            System.out.println("Jednosmerny? 1/0:");
            one_way = Integer.valueOf(input.readLine());
            if(one_way==0){
                System.out.println("Cas priletu:");
                arrival_time = Timestamp.valueOf(input.readLine());
            }
            Classes.print();
            System.out.println("Trieda:");
            class_id = Integer.valueOf(input.readLine());
            PassengerTypes.print();
            System.out.println("Druh pasažiera:");
            passenger_type = Integer.valueOf(input.readLine());
            System.out.println("User id:");
            user_id = Integer.valueOf(input.readLine());
            
        }catch(Exception e){
            System.out.println(e);
            return;
        }
        var res = TS.FlightDijkstraFinder.transactionFlightFinder(departure_id, arrival_id, departure_time, class_id, passenger_type, user_id);
        System.out.println("Cesta tam:");
        print_results(res, class_id, passenger_type, departure_id, arrival_id, user_id);
        if(one_way==0){
            System.out.println("Cesta späť:");
            res = TS.FlightDijkstraFinder.transactionFlightFinder(arrival_id, departure_id, arrival_time, class_id, passenger_type, user_id);
            print_results(res, class_id, passenger_type, arrival_id, departure_id, user_id);
        }
    }
    /**
    * print result of flight finding
    * @param res list of flight ids
    * @param class_id 
    * @param passenger_type 
    * @param departure_id 
    * @param arrival_id 
    * @param user_id 
    * @throws Exception
    */
    static void print_results(List<Integer> res, Integer class_id, Integer passenger_type, Integer departure_id, Integer arrival_id, Integer user_id ) throws Exception{
        System.out.println(res);
        if (res == null) {
            System.out.println("Nena\u0161iel som \u017eiadne lety");
            return;
        }
        System.out.println("Je tu takáto možnosť:");
        Float cena = 0.0F;
        System.out.println("\tID\tFlight\tDeparture time \t\t\tArrival time \t\t\tdist \tcompany \t\t\t\taircraft \t\t\t\tdeparture airport \t\tarrival airport \t\tCost\tFree seats");
        for (int j = 0; j < res.size(); j++) {
            System.out.print("\t");
            List let = FlightsFinder.findByID(res.get(j), class_id, passenger_type);
            cena += (Float)let.get(1);
            System.out.println((RDG.Flight)let.get(0)+"\t"+String.valueOf(let.get(1))+"\t"+String.valueOf(let.get(2)));
        }
        System.out.printf("Cena za tuto moznost normalna: %f\n", cena);
        System.out.printf("Cena za tuto moznost po zapocitani hladania: %f\n", cena + cena * Math.sqrt(Searchings.num(departure_id, arrival_id, user_id)));
    }
}
