package UI;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import RDG.*;

/**
 *
 * @author Marcel
 */
public class FlightsMenu {
    /**
    * Print Flight menu
    * @throws IOException
    */
    public static void FlightsMenu() throws IOException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        while(true){
            System.out.println("Lety. Možnosti:");
            System.out.println("1 - Zobraz lety");
            System.out.println("2 - Pridaj let");
            System.out.println("3 - Aktualizuj let");
            System.out.println("4 - Odstráň let");
            System.out.println("5 - return");
            String odpoved = input.readLine();
            
            try{
                switch(odpoved){
                    case "1" -> print();
                    case "2" -> AddFlight();
                    case "3" -> UpdateFlight();
                    case "4" -> DeleteFlight();
                    case "5" -> { return; }
                    default -> System.out.println("Skús ešte raz");
                }
            } catch(Exception e){
                System.out.println(e);
            }   
        }
    }
    /**
    * Print all flights.
    * @throws SQLException
    */
    public static void print() throws SQLException, IOException{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Zadaj cas od:");
        Timestamp from = Timestamp.valueOf(input.readLine());
        System.out.println("Zadaj cas do:");
        Timestamp to = Timestamp.valueOf(input.readLine());
        var res = FlightsFinder.SelectAll(from, to);
        BatchOutput.BatchPrint(res);
    }
    
    /**
    * Add flight to Flights
    * @throws SQLException
    * @throws IOException
    * @throws Exception
    */
    public static void AddFlight() throws IOException, SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Flight f = new Flight();
        try{
            System.out.println("Názov letu:");
            f.setName(input.readLine());
            System.out.println("Lietadlo (id):");
            f.setAircraft_id(Integer.valueOf(input.readLine()));
            System.out.println("Letisko odletu (id):");
            f.setDeparture_airport_id(Integer.valueOf(input.readLine()));
            System.out.println("Letisko príletu (id):");
            f.setArrival_airport_id(Integer.valueOf(input.readLine()));
            System.out.println("Čas odletu (yyyy-mm-dd hh:mm:ss):");
            f.setArrival_time(Timestamp.valueOf(input.readLine()));
            System.out.println("Čas príletu (yyyy-mm-dd hh:mm:ss):");
            f.setDeparture_time(Timestamp.valueOf(input.readLine()));
            System.out.println("Vzdialenosť:");
            f.setDistance(Integer.valueOf(input.readLine()));
            System.out.println("Spoločnosť (id):");        
            f.setCompany_id(Integer.valueOf(input.readLine()));
            System.out.println("Cenová tarifa (id):");        
            f.setFlight_cost_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
            
        f.insert();
       
        System.out.println("Let bol úspešne pridaný");
        System.out.print("ID: ");
        System.out.println(f.getFlight_id());
    }
    /**
    * Update Flight
    * @throws SQLException
    * @throws IOException
    * @throws Exception
    */
    public static void UpdateFlight() throws IOException, SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Flight f = new Flight();
        try{
            System.out.println("Let (id):");
            f.setFlight_id(Integer.valueOf(input.readLine()));

            System.out.println("Názov letu:");
            f.setName(input.readLine());
            System.out.println("Lietadlo (id):");
            f.setAircraft_id(Integer.valueOf(input.readLine()));
            System.out.println("Letisko odletu (id):");
            f.setDeparture_airport_id(Integer.valueOf(input.readLine()));
            System.out.println("Letisko príletu (id):");
            f.setArrival_airport_id(Integer.valueOf(input.readLine()));
            System.out.println("Čas odletu (yyyy-mm-dd hh:mm:ss):");
            f.setArrival_time(Timestamp.valueOf(input.readLine()));
            System.out.println("Čas príletu (yyyy-mm-dd hh:mm:ss):");
            f.setDeparture_time(Timestamp.valueOf(input.readLine()));
            System.out.println("Vzdialenosť:");
            f.setDistance(Integer.valueOf(input.readLine()));
            System.out.println("Spoločnosť (id):");        
            f.setCompany_id(Integer.valueOf(input.readLine()));
            System.out.println("Cenová tarifa (id):");        
            f.setFlight_cost_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        f.update();
       
        System.out.println("Let bol úspešne updatovaný");
    }
    /**
    * Delete Flight
    * @throws SQLException
    * @throws IOException
    * @throws Exception
    */
    public static void DeleteFlight() throws IOException, SQLException, Exception{
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        
        Flight f = new Flight();
        try{
            System.out.println("Let (id):");
            f.setFlight_id(Integer.valueOf(input.readLine()));
        } catch(Exception ignored){
            System.out.println(ignored);
            return;
        }
        
        f.delete();
       
        System.out.println("Let bol úspešne zmazaný");
    }
}
