package UI;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import RDG.*;

/**
 *
 * @author Marcel
 */
public class FractionOfMarket {
    
    /**
    * Print fraction of market between cities in one year period
    * @param from Timestamp
    * @param city_from Integer
    * @param city_to Integer
    * @throws SQLException
    */
    static public void printStats(Timestamp from, Integer city_from, Integer city_to) throws SQLException{
        Calendar c = Calendar.getInstance();
        c.setTime(from);
        c.add(Calendar.YEAR, 1);
        Timestamp to = new Timestamp(c.getTimeInMillis());
        var res = FractionOfMarketDB.selectStats(from,to, city_from, city_to);
        if(res==null || res.isEmpty()){
            System.out.println("Nenašiel som v danom dátume žiadne lety");
            return;
        }
        System.out.println("Od "+from+" do "+to);
        System.out.println("%\t\tID");
        for(String s:res.keySet()){
            System.out.println(res.get(s)+"%\t"+s);
        }
    }
    
    /**
    * Print menu for counting Fraction of market stats
    */
    static public void Menu(){
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        Timestamp from;
        Integer city_from, city_to;
        try{
            System.out.println("Ok, zistiť podiel na trhu. Zadaj dátum od ktorého budeme rátať rok (YYYY-MM-DD HH:MM:SS)");
            from = Timestamp.valueOf(input.readLine());
            System.out.println("Z ktorého mesta?");
            city_from = Integer.valueOf(input.readLine());
            System.out.println("Do ktorého mesta?");
            city_to = Integer.valueOf(input.readLine());
            printStats(from, city_from, city_to);
        }catch(Exception e){
            System.out.println(e);
            return;
        }
    }
}
