package com.example.drievka

import android.content.Context
import android.graphics.*
import android.util.AttributeSet
import android.util.Log
import android.view.View

class ProgressBar(internal var context: Context, attrs: AttributeSet)
    : View(context, attrs) {

        var level = 1
        var max = 10
        var pwidth = 0f
        var pheight = 0f
        var paintFill = Paint()
        var paintStroke = Paint()
        var transparentPaintFill = Paint()
        var transparentPaintStroke = Paint()
        var lowerRect = RectF()
        var upperRect = RectF()
        var smallRect = RectF()
        var paintFillBlue = Paint()

    init {

        paintFillBlue = Paint().apply {
            style = Paint.Style.FILL
            color = Color.BLUE
            textSize = 100F
        }

        paintFill = Paint().apply {
            style = Paint.Style.FILL
            color = Color.YELLOW
            textSize = 100F
        }

        paintStroke = Paint().apply {
            style = Paint.Style.STROKE
            color = Color.BLACK
            strokeWidth = 5f
            textSize = 100F
        }

        transparentPaintFill = Paint().apply {
            style = Paint.Style.FILL
            color = Color.YELLOW
            textSize = 100F
        }
        transparentPaintStroke = Paint().apply {
            style = Paint.Style.STROKE
            color = Color.BLACK
            strokeWidth = 5f
            textSize = 100F
        }
        transparentPaintFill.alpha = 20
        transparentPaintStroke.alpha = 20
    }


    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)

        canvas.drawRoundRect(lowerRect, 20f,20f, paintFill)
        canvas.drawRoundRect(smallRect, 20f,20f, paintFillBlue)


    }

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        Log.d("STICK", "Width w= " + w + " height h=" + h)
        super.onSizeChanged(w, h, oldw, oldh)
        pwidth = w.toFloat()
        pheight = h.toFloat()

        var radX = pwidth / 3

        var rectSide = pheight / 11


        lowerRect = RectF(radX,10f, radX*2, pheight - 20f )

        smallRect = RectF(radX + 5, pheight - radX - 25f, radX* 2f - 10, pheight - 25)



    }
}