package com.example.drievka

import android.content.Context
import android.graphics.*
import android.util.AttributeSet
import android.view.View
import kotlinx.android.synthetic.main.hra1.view.*

class Task(internal var context: Context, attrs: AttributeSet)
    : View(context, attrs) {

        var usedSticks = 0
            get() {
                return field
            }
            set(value) { field = value}
        var allSticks = 0
            get() {
                return field
            }
            set(value) { field = value}
        var createdShapes = 0
            get() {
                return field
            }
            set(value) { field = value}
        var allShapes = 0
            get() {
                return field
            }
            set(value) { field = value}
        var square = false
        get() {
            return field
        }
        set(value) { field = value}
        var pwidth = 0f
        var pheight = 0f
        val TAG = "TASK"
        var radX = 0f
        var radY = 0f
        var rectf = RectF()
        val round = 20F
        var paintFill = Paint()
        var paintStroke = Paint()
        var paintYellowStroke = Paint()
        var path = Path()


    init{
        paintFill = Paint().apply {
            style = Paint.Style.FILL
            color = Color.YELLOW
            textSize = 120F
        }
        paintStroke = Paint().apply {
            style = Paint.Style.STROKE
            color = Color.BLACK
            strokeWidth = 5f
            textSize = 120F
        }

        paintYellowStroke = Paint().apply {
            style = Paint.Style.STROKE
            color = Color.YELLOW
            strokeWidth = 20f
            textSize = 120F
        }
    }

    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)

        canvas.drawRoundRect(rectf, round, round, paintFill)
        canvas.drawRoundRect(rectf, round, round, paintStroke)

        canvas.drawText(
            "" + usedSticks + "/" + allSticks,
            rectf.right + radX,
            rectf.centerY(),
            paintFill
        )
        canvas.drawText(
            "" + usedSticks + "/" + allSticks,
            rectf.right + radX,
            rectf.centerY(),
            paintStroke
        )

        if (square){
            canvas.drawRect(
                rectf.right + radY * 2,
                radX / 2,
                rectf.right + radY * 3,
                radX / 2 + radY,
                paintYellowStroke
            )
        }else{
            canvas.drawPath(path, paintYellowStroke)
        }
        canvas.drawText(
            "" + createdShapes + "/" + allShapes,
            rectf.right + radY * 3 + radX,
            rectf.centerY(),
            paintFill
        )
        canvas.drawText(
            "" + createdShapes + "/" + allShapes,
            rectf.right + radY * 3 + radX,
            rectf.centerY(),
            paintStroke
        )
    }

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
        pwidth = w.toFloat()
        pheight = h.toFloat()

        radY = pheight * 0.8f
        radX = pwidth * 0.02f

        rectf = RectF(radX, radX / 2, radX + radX, radX + radY)

        val p1 = PointF(rectf.right + radY * 2, radX / 2 + radY)
        val p2 = PointF(rectf.right + radY * 2.5f, radX/2)
        val p3 = PointF(rectf.right + radY * 3, radX / 2 + radY)

//            path.setFillType(Path.FillType.EVEN_ODD)
        path.moveTo(p1.x, p1.y)
        path.lineTo(p2.x, p2.y)
        path.lineTo(p3.x, p3.y)
        path.close()

    }




}