 // -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*-
  
 #include <string>
 #include <cstdio>
 #include <stdio.h>
 #include <iostream>
 #include <vector>
#include <algorithm>


 #include <yarp/os/Network.h>
 #include <yarp/dev/ControlBoardInterfaces.h>
 #include <yarp/dev/PolyDriver.h>
 #include <yarp/os/Time.h>
 #include <yarp/sig/Vector.h>

#include "side.h"

 #include "constants.cpp"
  
 using namespace std;
 using namespace yarp::dev;
 using namespace yarp::sig;
 using namespace yarp::os;




void gaze(IPositionControl *pos, Vector command, int step, int num_steps)
{

    for(int i=0; i<num_steps; i++)
    {
        command[4]+=step;
        int head_step = -HEAD_STEP;
        if(step < 0)
        {
            head_step = HEAD_STEP;
        }
        command[1]+=head_step;
        command[2]+=head_step;
        pos->positionMove(command.data());
    }

    bool done=false;
  
     while(!done)
     {
         pos->checkMotionDone(&done);
     }
    
    
    command[1]=0;
    command[2]=0;
    command[4]=0;
    pos->positionMove(command.data());

    done=false;
  
     while(!done)
     {
         pos->checkMotionDone(&done);
     }
}

void gaze_right(IPositionControl *pos, Vector command)
{

    gaze(pos, command, -EYE_STEP, 1);
    
}

void gaze_left(IPositionControl *pos, Vector command)
{

    gaze(pos, command, EYE_STEP, 1);
}

void set_to_init_position(IPositionControl *pos, Vector command)
{
     command[0]=INIT_HEAD_POSITION; // look a little up
     command[1]=0;
     command[2]=0;
     command[3]=0;
     command[4]=0;
     command[5]=0;
     pos->positionMove(command.data()); // set head joints positions
}

void set_acceleration(IPositionControl *pos, Vector command)
{
    int nj=0;
     pos->getAxes(&nj);
     for (int i = 0; i < nj; i++) 
     {
          command[i] = ROBOT_ACCELERATION;
     }
     pos->setRefAccelerations(command.data());

}

void set_speed(IPositionControl *pos, Vector command)
{
    int nj=0;
     pos->getAxes(&nj);
     for (int i = 0; i < nj; i++) 
     {
         command[i] = ROBOT_SPEED;
         pos->setRefSpeed(i, command[i]);
     }
}

void create_confs(vector<pair<side, side>>& confs)
{

    const int N = NUM_OF_ONE_CONF; // later 20
    for(int i=0; i<N; i++)
    {
        confs.push_back(make_pair(side::left, side::left));
    }
    for(int i=0; i<N; i++)
    {
        confs.push_back(make_pair(side::left, side::right));
    }
    for(int i=0; i<N; i++)
    {
        confs.push_back(make_pair(side::right, side::left));
    }
    for(int i=0; i<N; i++)
    {
        confs.push_back(make_pair(side::right, side::right));
    }
    std::random_shuffle(confs.begin(), confs.end());
}

 int main(int argc, char *argv[]) 
 {
     Network yarp;
     if (!yarp.checkNetwork())
     {
         fprintf(stdout,"Error: yarp server not available\n");
         return 1;
     }
  
     Property params;
     params.fromCommand(argc, argv);
  
     if (!params.check("robot"))
     {
         fprintf(stderr, "Please specify the name of the robot\n");
         fprintf(stderr, "--robot name (e.g. icub)\n");
         return 1;
     }

     string robotName=params.find("robot").asString();
     string remotePorts="/";
     remotePorts+=robotName;
     remotePorts+="/head";
     cout<<"remote : "<<remotePorts<<endl;
  
     string localPorts="/test/client";
  
     Property options;
     options.put("device", "remote_controlboard");
     options.put("local", localPorts);   //local port names
     options.put("remote", remotePorts); //where we connect to
  
     // create a device
     PolyDriver robotDevice(options);
     if (!robotDevice.isValid()) 
     {
         printf("Device not available.  Here are the known devices:\n");
         //printf("%s", Drivers::factory().toString().c_str());
         return 0;
     }
  
     IPositionControl *pos;
     IEncoders *encs;
  
     bool ok;
     ok = robotDevice.view(pos);
     ok = ok && robotDevice.view(encs);
  
     if (!ok) 
     {
         printf("Problems acquiring interfaces\n");
         return 0;
     }
  
     int nj=0;
     pos->getAxes(&nj);
     Vector encoders;
     Vector command;
     Vector tmp;
     encoders.resize(nj);
     tmp.resize(nj);
     command.resize(nj);
     command=encoders;
     
     //fisrst read all encoders
     //
     printf("waiting for encoders");
     while(!encs->getEncoders(encoders.data()))
     {
         Time::delay(1);
         printf(".");
     }
     printf("\n;");
  
     set_acceleration(pos, tmp);
     set_speed(pos, tmp);
     set_to_init_position(pos, command);
     
     bool done=false;
  
     while(!done)
     {
         pos->checkMotionDone(&done);
     }

     //cout<<"start creating light"<<endl;
     //BufferedPort<Bottle> lightPort;
     //Port lightPort;
     //lightPort.open(Contact("/icubSim/tmpWorld"));
     //Network::connect("/icubSim/tmpWorld", "icubSim/world");
     //Bottle& output = lightPort.prepare();
     //output.clear();
     //output.addString("world mk ssph 1 2 2 2 2 2 2");
     //lightPort.write();
     //cout<<"end creating light"<<endl;

     vector<pair<side,side>> confs;
     create_confs(confs);

     for(auto c : confs)
     {
         switch (c.first)
         {
             case side::left:
                 cout<<"left"<<endl;
                 gaze_left(pos, command);
                 break;
             case side::right:
                 cout<<"right"<<endl;
                 gaze_right(pos, command);
                 break;
         }
     }
     robotDevice.close();
     
     return 0; 
}

void create_light()
{

}
