#ifndef BA_GRAPH_OPERATIONS_COPIES_HPP
#define BA_GRAPH_OPERATIONS_COPIES_HPP

namespace ba_graph
{

// preserves both numbers and vertices
inline Graph copy_identical(const Graph &G, Factory &f = static_factory)
{
#ifdef BA_GRAPH_DEBUG
    assert(check(G, f));
#endif
    //TODO keep embeding
        Graph H(createG(f));
        for (auto &r : G)
            addV(H, r.v(), r.n(), f);
        change_via_builder(H, [&](auto &H) {
            for (auto &r : G) {
                changeVertexDegree(H, r.n(), r.degree(), f);
                for(int inc_no = 0; inc_no < r.degree(); inc_no++){
                    setIncidence(H, r[inc_no].n1(), inc_no, r[inc_no].n2(), r[inc_no].h1());
                }
            }
        });
        return H;
}

// preserves only numbers (and graph structure), vertices are newly created
template <typename T = NoMapper>
typename OneExtraReturnValue<Graph, T>::ReturnType copy_disjoint(const Graph &G, Factory &f)
{
#ifdef BA_GRAPH_DEBUG
    assert(check(G, f));
#endif
        //TODO keep embeding
        Graph H(createG(f));
        typename T::MappingType l;


        change_via_builder(H, [&](auto &H) {
            for (auto &r : G) {
                addRotation(H, r.n(), f);
                reserveDegree(H, r.n(), r.degree(), f);
            }
            for (auto ii : G.list(RP::all(), IP::primary())) {
                Edge e = createE( ii->v1(), ii->v2());
                addIncidence(H, ii->n1(), ii->n2(), e.h1(), f);
                addIncidence(H, ii->n2(), ii->n1(), e.h2(), f);
                T::addE(l, ii->e(), e);
            }
        });
        return OneExtraReturnValue<Graph, T>::ret(H, l);}

template <typename T = NoMapper>
typename OneExtraReturnValue<Graph, T>::ReturnType copy_disjoint(const Graph &G)
{
    return copy_disjoint<T>(G, static_factory);
}

// preserves only numbers (and graph structure), vertices and edges come from another factory
template <typename T = NoMapper>
typename OneExtraReturnValue<Graph, T>::ReturnType copy_other_factory(const Graph &G, Factory &f)
{
        //TODO keep embeding
        Graph H(createG(f));
        typename T::MappingType l;
        change_via_builder(H, [&](auto &H) {
            for (auto &r : G) {
                addRotation(H, r.n(), f);
                reserveDegree(H, r.n(), r.degree(), f);
            }
            for (auto ii : G.list(RP::all(), IP::primary())) {
                Edge e = createE( ii->v1(), ii->v2());
                addIncidence(H, ii->n1(), ii->n2(), e.h1(), f);
                addIncidence(H, ii->n2(), ii->n1(), e.h2(), f);
                T::addE(l, ii->e(), e);
            }
        });
        return OneExtraReturnValue<Graph, T>::ret(H, l);
    }

} // namespace ba_graph

#endif
