#ifndef BA_GRAPH_BUILDER_HPP
#define BA_GRAPH_BUILDER_HPP

#include "builder.h"

namespace ba_graph {


#ifdef BA_GRAPH_DEBUG
    GraphBuilder::GraphBuilder(Graph &g): edge_count(2 * g.edge_count), my_factory(g.my_factory), free_number(g.free_number) {
        std::swap(rr_, g.rr_);
    }
#else
    GraphBuilder::GraphBuilder(Graph &g): edge_count(2 * g.edge_count),free_number(g.free_number) {
        std::swap(rr_, g.rr_);
    }
#endif

    Graph GraphBuilder::to_graph() {
#ifdef BA_GRAPH_DEBUG
        Graph G (my_factory);
#else
        Graph G;
#endif
        G.edge_count = edge_count / 2;
        G.free_number = free_number;
        G.rr_ = std::move(rr_);
        return G;
    }

}

#endif