#include <impl/basic.hpp>
#include "graph3colouring.hpp"

using namespace ba_graph;

class TwoBisections {
    private:
        const Graph &g;
        Graph3Colouring colours;

        bool three_consecutive(Number v, bool first = true){
            int same = 0;
            Number colour = colours.get_colour(v);
            Number same_neighbour;

            for(const auto neighbour : g[v].neighbours()){
                if(colours.get_colour(neighbour) == colour){
                    same++;
                    same_neighbour = g[neighbour].n();
                }
            }

            return same>=2 || (first && same>0 && three_consecutive(same_neighbour,false));
        }

        int recolour_independent_set(RotationIterator it) {
            if(it == g.end()){
                return 1;
            }

            Number v = it->n();

            if(colours.get_colour(v) == 3){
                it++;

                colours.set_colour(v, -1);
                int f = 0;
                if(!three_consecutive(v))
                    f = this->recolour_independent_set(it);

                colours.set_colour(v, -2);
                int s = 0;
                if(!three_consecutive(v))
                    s = this->recolour_independent_set(it);

                colours.set_colour(v, 3);
                return f + s;
            }

            return this->recolour_independent_set(++it);
        }

        int recolour(RotationIterator it){
            if(it == g.end()){
                return recolour_independent_set(g.begin());
            }

            Number v = it->n();

            if(colours.get_colour(v) != 3){
                it++;

                colours.set_colour(v, -1);
                int f = 0;
                if(!three_consecutive(v))
                    f = this->recolour(it);

                colours.set_colour(v, -2);
                int s = 0;
                if(!three_consecutive(v))
                    s = this->recolour(it);

                colours.set_colour(v, 0);
                return f + s;
            }

            return this->recolour(++it);
        }

    public:
        TwoBisections(const Graph &graph): g(graph), colours(graph) {}

        int enumerate(){
            if(!colours.colour_graph()){
                return 0;
            }

            return recolour(g.begin());
        }
};
