#include <set>
#include <bits/stdc++.h>
#include <impl/basic.hpp>
#include "maximalindependentset.hpp"

using namespace ba_graph;
using namespace std;

class Graph3Colouring {
    private:
        const Graph &g;
        Mapping<Number> colours;
        MaximalIndependentSet independent_set;

        void reset_colours() {
            for(auto it = g.begin(); it != g.end(); it++){
                colours.set(it->n(), 0);
            }
        }

        bool colour_vertex(Number v, Number colour) {
            if(independent_set.get_maximal_independent_set().count(v) == 1){
                colours.set(v, 3);
                return true;
            }

            Number last_colour = colours.get(v);
            colours.set(v, colour);
            return last_colour == colour;
        }

        bool colour_vertices(Number v, Number colour) {
            if(colours.get(v) > 0){
                if(!colour_vertex(v, colour)){
                    return false;
                }

                return true;
            }

            colour_vertex(v, colour);
            if(colours.get(v) == 3){
                return true;
            }

            for(auto neighbour : g[v].neighbours()){
                if(!colour_vertices(neighbour, (colour.to_int() % 2) + 1)) {
                    return false;
                }
            }

            return true;
        }

    public:
        Graph3Colouring(const Graph &graph): g(graph), independent_set(graph) {}

        bool colour_graph() {
            independent_set.generate_maximal_independent_set();

            bool end = false;
            while(!end){
                reset_colours();

                end = true;
                for(auto it = g.begin(); it != g.end(); it++){
                    Number v = it->n();
                    if((colours.get(v) == 0) && (!colour_vertices(v, 1))){
                        end = false;
                    }
                }

                if((!end) && (!independent_set.next_maximal_independent_set())){
                    return false;
                }
            }

            return true;
        }

        Number get_colour(Number v) {
            return colours.get(v);
        }

        void set_colour(Number v, Number colour){
            colours.set(v, colour);
        }

        set<Number> get_independent_set() {
            return independent_set.get_maximal_independent_set();
        }
};