#include <set>
#include <bits/stdc++.h>
#include <impl/basic.hpp>

using namespace ba_graph;
using namespace std;

class MaximalIndependentSet {
    private:
        const Graph &g;
        set<Number> independent_set;
        set<Number> unused_vertices;

        bool generate_rest_of_maximal_independent_set(){
            for(auto it = unused_vertices.begin(); unused_vertices.size() > 0; it = unused_vertices.begin()) {
                if((independent_set.size() > 0) && (unused_vertices.size() > 0) && (*(--independent_set.end()) > *(--unused_vertices.end()))){
                    return false;
                }

                independent_set.insert(*it);

                for(const auto neighbour : g[*it].neighbours()) {
                    unused_vertices.erase(neighbour.to_int());
                }
                unused_vertices.erase(*it);
            }

            return true;
        }

    public:
        MaximalIndependentSet(const Graph &graph): g(graph) {}

        bool generate_maximal_independent_set() {
            independent_set.clear();
            unused_vertices.clear();
            for(auto it = g.begin(); it != g.end(); it++){
                unused_vertices.insert(it->n());
            }

            return generate_rest_of_maximal_independent_set();
        }

        bool next_maximal_independent_set() {
            while(true) {
                if(independent_set.begin() == independent_set.end()){
                    return false;
                }

                auto remove = *(--independent_set.end());
                independent_set.erase(remove);

                Number next = INT_MAX;
                for(const auto neighbour : g[remove].neighbours()) {
                    bool add = true;
                    for(const auto n : g[neighbour].neighbours()){
                        if(independent_set.count(n) == 1){
                            add = false;
                            break;
                        }
                    }
                    if(add){
                        unused_vertices.insert(neighbour);

                        if((neighbour > remove) && (next > neighbour)) {
                            next = neighbour;
                        }
                    }
                }
                unused_vertices.insert(remove);

                if(next < INT_MAX){
                    for(const auto neighbour : g[next].neighbours()) {
                        unused_vertices.erase(neighbour);
                    }
                    unused_vertices.erase(next);
                    independent_set.insert(next);
                    break;
                }
            }
            
            return generate_rest_of_maximal_independent_set();
        }

        const set<Number> &get_maximal_independent_set() {
            return independent_set;
        }
};