#include <impl/basic.hpp>

using namespace ba_graph;

class TwoBisections {
    private:
        const Graph &g;
        Mapping<int> colours;
        //temporary coloring O(3^|V(G)|)
        bool colour_graph(RotationIterator it,int max_colours = 3){
            if(g.end() == it){
                return true;
            }

            int v = it->v().to_int();

            for(int i = 1; i <= max_colours; i++){
                colours.set(v,i);
                bool safe = true;
                
                for(const auto neighbour : g[v].neighbours()){
                    if(colours.get(neighbour.to_int()) == i){
                        safe = false;
                        break;
                    }
                }
                
                if(safe){
                    return colour_graph(it++,max_colours);
                }
            }

            return false;
        }

        //write check for testing proper colouring
        bool check() {
            return true;
        }

        bool three_consecutive(Vertex vertex, bool first = true){
            int same = 0;
            int v = vertex.to_int();
            int colour = colours.get(v);
            Vertex same_neighbour;

            for(const auto neighbour : g[v].neighbours()){
                if(colours.get(neighbour.to_int()) == colour){
                    same++;
                    same_neighbour = g[neighbour.to_int()].v();
                }
            }

            return same==2 || (first && same>0 && three_consecutive(same_neighbour,false));
        }

        int recolour(RotationIterator it){
            if(it==g.end()){
                return check();
            }

            int v = it->v().to_int();

            if(colours.get(v)==3){
                it++;

                colours.set(v,1);
                int f = 0;
                if(three_consecutive(it->v()))
                    f = this->recolour(it);

                colours.set(v,2);
                int s = 0;
                if(three_consecutive(it->v()))
                    s = this->recolour(it);

                return f+s;
            }

            return this->recolour(it++);
        }

    public:
        TwoBisections(const Graph &graph): g(graph) {}

        int enumerate(){
            if(colour_graph(g.begin())){
                return 0;
            }

            return recolour(g.begin());
        }
};
