import  PIL
import numpy as np
from PIL import ImageDraw
import PIL.Image
from pygame import image


class Image:
    def __init__(self, image_file,size):
        #nastavima zdroj obrazku
        self.originimage = image_file
        self.image = PIL.Image.open(image_file)
        self.set_size(size)
        # original obrazok pre resize

    # vráti veľkosť obrázka
    def get_size(self):
        return self.image.size

    def get_rect(self):
        mode = self.image.mode
        size = self.image.size
        data = self.image.tobytes()

        return image.fromstring(data, size, mode)

    # ukáže obrázok
    def showimage(self):
       self.image.show()


    def set_to_round(self):
        # pieslice() funkcian aby sme dostlai kruhovú časťo brázka bielou,
        # preložime s originálom a vytoríme luminous image.
        # vytváranie luminous image
        vyska , sirka = self.get_size()
        lum_img = PIL.Image.new('L', [vyska, sirka], 0)
        draw = ImageDraw.Draw(lum_img)
        draw.pieslice([(0, 0), (vyska, sirka)], 0, 360, fill=255)
        # image array
        img_arr = np.array(self.image)
        # luminous array
        lum_img_arr = np.array(lum_img)
        #preložíme a vyrežeme kruhovú časť
        final_img= np.dstack((img_arr, lum_img_arr))
        self.image = PIL.Image.fromarray(final_img)

    # zmení veľkosť obrázka
    def set_size(self,size):
        if (size <= 8):
            self.image = PIL.Image.open(self.originimage)
            #self.image.thumbnail((25 * size, 25 * size)) zachova dimenzie
            self.image = self.image.resize((25 * size, 25 * size))
        else:
            self.image = PIL.Image.open(self.originimage)
            #self.image.thumbnail((200,200)) zachova dimenzie
            self.image = self.image.resize((25 * size, 25 * size))

if __name__ == "__main__":
    myImage = Image('character.jpg', 4)
    myImage.set_size(4)
    myImage.set_to_round()
    myImage.showimage()



