import flask
from flask import Flask
from helpers import createLocalDB, populateData, getUserData
from tables import db
from apscheduler.schedulers.background import BackgroundScheduler
import time
import atexit


app = Flask(__name__)

app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///data.db"
db.init_app(app)

tables = ["users",
          "user_info",
          "contact_types",
          "user_contact_varchar",
          "user_contact_text",
          # "user_contact_photo",
          "workplace_users",
          "workplace_langs",
          "workplaces",
          "user_workplace_permissions",
          "job_titles",
          "job_title_langs",
          #  "job_type_langs",
          "publications"]

# createLocalDB(db, app)
# populateData(db, app, tables)


@app.route('/<user_login>')
def userInfo(user_login):
    """ Displays the index page accessible at '/'
    """

    data = getUserData(db, user_login)
    if data is not None:
        return data

    return {'err': 'Notfound'}, 404


# def updateLocalDB():
#     with app.app_context():
#         populateData(db, app, tables)


if __name__ == '__main__':
    def updateLocalDB():
        with app.app_context():
            populateData(db, app, tables)

    scheduler = BackgroundScheduler()
    scheduler.add_job(func=updateLocalDB, trigger="interval", seconds=3600)
    scheduler.start()

    # Shut down the scheduler when exiting the app
    atexit.register(lambda: scheduler.shutdown())

    app.debug = True
    app.run(host="0.0.0.0")
