from flask_sqlalchemy import SQLAlchemy

db = SQLAlchemy()


# models for local database tables
class Users(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    login = db.Column(db.String(128))
    uoc = db.Column(db.Integer())
    deleted = db.Column(db.Integer())


class UserInfo(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    user_id = db.Column(db.Integer(), db.ForeignKey('users.id'))
    updated = db.Column(db.DateTime())
    first_name = db.Column(db.String(255))
    middle_name = db.Column(db.String(255))
    last_name = db.Column(db.String(255))
    title_before = db.Column(db.String(128))
    title_after = db.Column(db.String(128))
    maiden_name = db.Column(db.String(255))


class ContactTypes(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    name = db.Column(db.String(255))
    displayable = db.Column(db.Integer())
    editable = db.Column(db.Integer())
    data_type = db.Column(db.String())  # enum: int, double, varchar, text, photo
    input_type = db.Column(db.String())  # enum: input, file, textarea, select, static/input


class UserContactVarchar(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    value = db.Column(db.String(255))
    visible = db.Column(db.Integer())
    workplace_user_id = db.Column(db.Integer(), db.ForeignKey('workplace_users.id'))
    contact_type_id = db.Column(db.Integer(), db.ForeignKey('contact_types.id'))
    language = db.Column(db.String(5))
    cdo_id = db.Column(db.Integer())
    deleted = db.Column(db.Integer())


class UserContactText(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    value = db.Column(db.Text())
    visible = db.Column(db.Integer())
    workplace_user_id = db.Column(db.Integer(), db.ForeignKey('workplace_users.id'))
    contact_type_id = db.Column(db.Integer(), db.ForeignKey('contact_types.id'))
    language = db.Column(db.String(5))
    cdo_id = db.Column(db.Integer())
    deleted = db.Column(db.Integer())


class UserContactPhoto(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    value = db.Column(db.LargeBinary())
    filename = db.Column(db.String(255))
    extension = db.Column(db.String(5))
    workplace_user_id = db.Column(db.Integer(), db.ForeignKey('workplace_users.id'))
    contact_type_id = db.Column(db.Integer(), db.ForeignKey('contact_types.id'))
    language = db.Column(db.String(5))
    cdo_id = db.Column(db.Integer())
    deleted = db.Column(db.Integer())


class WorkplaceUsers(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    user_id = db.Column(db.Integer(), db.ForeignKey('users.id'))
    workplace_id = db.Column(db.Integer())  # , db.ForeignKey('******'))
    job_title_id = db.Column(db.Integer(), db.ForeignKey('job_titles.id'))
    default = db.Column(db.Integer)
    is_leader = db.Column(db.Integer())
    cdo_id = db.Column(db.String(64))
    deleted = db.Column(db.Integer())
    job_type_id = db.Column(db.Integer())  # , db.ForeignKey('******'))


class WorkplaceLangs(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    workplace_id = db.Column(db.Integer())  # , db.ForeignKey('******'))
    language = db.Column(db.String(5))
    title = db.Column(db.String(512))
    abbreviation = db.Column(db.String(32))


class Workplaces(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    tree_path = db.Column(db.String(256))
    deleted = db.Column(db.Integer())


class UserWorkplacePermissions(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    user_id = db.Column(db.Integer(), db.ForeignKey('users.id'))
    workplace_id = db.Column(db.Integer())  # , db.ForeignKey('******'))


class JobTitles(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    deleted = db.Column(db.Integer())


class JobTitleLangs(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    job_title_id = db.Column(db.Integer(), db.ForeignKey('job_titles.id'))
    language = db.Column(db.String(5))
    full_job_title = db.Column(db.String())


# class JobTypeLangs(db.Model):
#     id = db.Column(db.Integer(), primary_key=True)
    #     updated = db.Column(db.DateTime())
#     jobTypeId = db.Column(db.Integer(10))  # , db.ForeignKey('******'))
#     language = db.Column(db.String(5))
#     value = db.Column(db.String(255))
#     singularForm = db.Column(db.String(255))


class Publications(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    updated = db.Column(db.DateTime())
    user_id = db.Column(db.Integer(), db.ForeignKey('users.id'))
    auth_id = db.Column(db.Integer())


class LastUpdate(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    time = db.Column(db.DateTime())