import glob
import cv2 as cv
import numpy as np
from skimage.feature import local_binary_pattern

def readImages(name):
    # citanie obrazkov
    images = []
    path = glob.glob(name)
    for file in path:
        image = cv.imread(file)
        images.append(image)

    return images


def extractRGBMeanStd(image):
    # find maximum contour in image
    # return mean color, deviation of color
    gray = cv.cvtColor(image, cv.COLOR_BGR2GRAY)
    _, binary = cv.threshold(gray, 0, 255, cv.THRESH_BINARY + cv.THRESH_OTSU)
    contours, _ = cv.findContours(binary, cv.RETR_EXTERNAL, cv.CHAIN_APPROX_SIMPLE)
    contour = max(contours, key=cv.contourArea)
    mask = np.zeros(gray.shape, dtype=np.uint8)
    cv.drawContours(mask, [contour], -1, 255, -1)
    
    mean_color = cv.mean(image, mask=mask)[:3]
    std_color = [np.std(image[:, :, i][mask == 255]) for i in range(3)]

    return mean_color[2], std_color[2]
def extractTextureFeatures(image):
    # return textures flags
    gray = cv.cvtColor(image, cv.COLOR_BGR2GRAY)
    _, binary = cv.threshold(gray, 0, 255, cv.THRESH_BINARY + cv.THRESH_OTSU)
    contours, _ = cv.findContours(binary, cv.RETR_EXTERNAL, cv.CHAIN_APPROX_SIMPLE)
    if not contours:
        return None
    contour = max(contours, key=cv.contourArea)
    mask = np.zeros_like(gray, dtype=np.uint8)
    cv.drawContours(mask, [contour], -1, 255, -1)

    laplacian = cv.Laplacian(gray, cv.CV_64F)
    laplacian_var = np.var(laplacian[mask == 255])
    sobelx = cv.Sobel(gray, cv.CV_64F, 1, 0, ksize=5)
    sobely = cv.Sobel(gray, cv.CV_64F, 0, 1, ksize=5)
    sobel_mag = np.sqrt(sobelx**2 + sobely**2)
    sobel_var = np.var(sobel_mag[mask == 255])
    lbp = local_binary_pattern(gray, P=8, R=1, method="uniform")
    lbp_hist, _ = np.histogram(lbp[mask == 255], bins=np.arange(0, 11), density=True)
    lbp_entropy = -np.sum(lbp_hist * np.log2(lbp_hist + 1e-6))

    return laplacian_var, sobel_var,  lbp_entropy
def extractGeometricFeatures(image):
    # return perimeter
    gray = cv.cvtColor(image, cv.COLOR_BGR2GRAY)
    _, binary = cv.threshold(gray, 0, 255, cv.THRESH_BINARY + cv.THRESH_OTSU)
    contours, _ = cv.findContours(binary, cv.RETR_EXTERNAL, cv.CHAIN_APPROX_SIMPLE)
    contour = max(contours, key=cv.contourArea)

    perimeter = cv.arcLength(contour, True)
    return perimeter
def extractHSVSaturationArea(image):
    # return HSV saturation but better
    hsv = cv.cvtColor(image, cv.COLOR_BGR2HSV)
    saturation = hsv[:, :, 1]

    _, mask = cv.threshold(saturation, 20, 255, cv.THRESH_BINARY)
    mask = cv.GaussianBlur(mask, (9, 9), 0)
    _, mask = cv.threshold(mask, 10, 255, cv.THRESH_BINARY)
    mask_bool = mask.astype(bool)
    average_saturation = np.mean(saturation[mask_bool])

    return average_saturation
def extractHSVMean(image):
    # convert to HSV - find value uf mean for red color
    hsv = cv.cvtColor(image, cv.COLOR_BGR2HSV)
    mean_h = np.mean(hsv[:, :, 0])  # Hue
    return mean_h

def testColors(name):
    photos = readImages(name)

    valuesA = []
    valuesB = []
    for image in photos:
        result = extractRGBMeanStd(image)
        mean = result[0]
        std = result[1]
        valuesA.append(mean)
        valuesB.append(std)

    return np.median(valuesA), np.median(valuesB)
def testTextures(name):
    photos = readImages(name)

    valuesA = []
    valuesB = []
    valuesC = []
    for image in photos:
        result = extractTextureFeatures(image)
        mean = result[0]
        std = result[1]
        num = result[2]
        valuesA.append(mean)
        valuesB.append(std)
        valuesC.append(num)

    return np.median(valuesA), np.median(valuesB), np.median(valuesC)
def testGeometric(name):
    photos = readImages(name)

    values = []
    for image in photos:
        result = extractGeometricFeatures(image)
        num = result
        values.append(num)

    return np.median(values)
def testSaturation(name):
    photos = readImages(name)

    values = []
    for image in photos:
        result = extractHSVSaturationArea(image)
        num = result
        values.append(num)

    return np.median(values)
def testMean(name):
    photos = readImages(name)

    values = []
    for image in photos:
        result = extractHSVMean(image)
        num = result
        values.append(num)

    return np.median(values)
def classify(name):
    photos = readImages(name)
    index = 1
    for image in photos:
        numberMoulds = 0
        numberBacteria = 0

        value1 = extractHSVSaturationArea(image)
        result = extractRGBMeanStd(image)
        mean = result[0]
        std = result[1]

        if value1 >= dustSat: numberBacteria += 1
        elif value1 < dustSat: numberMoulds += 1

        if mean >= dustMean: numberBacteria += 1
        elif mean < dustMean: numberMoulds += 1

        if std >= dustStd: numberMoulds += 1
        elif std < dustStd: numberBacteria += 1

        if numberMoulds >= 2: print(f"{index}: M")
        elif numberBacteria >= 2: print(f"{index}: B")
        else: print(f"{index}: Not classified")

        index += 1


# reading images
photosPath = "./data/*.jpg"
mouldsPath = "./plesne/*.jpg"
bacteriaPath = "./bakterie/*.jpg"

# train
meanR, stdR = testColors(mouldsPath)
medianMeanMould = meanR
medianStdMould = stdR

meanR, stdR = testColors(bacteriaPath)
medianMeanBacteria = meanR
medianStdBacteria = stdR

dustMean = (medianMeanBacteria + medianMeanMould) / 2
dustStd = (medianStdBacteria + medianStdBacteria) / 2

num1, num2, num3 = testTextures(mouldsPath)
medianLMould = num1
medianSMould = num2
medianBMould = num3

num1, num2, num3 = testTextures(bacteriaPath)
medianLBacteria = num1
medianSBacteria = num2
medianBBacteria = num3

dustL = (medianLBacteria + medianLMould) / 2
dustS = (medianSBacteria + medianSMould) / 2
dustB = (medianBBacteria + medianBMould) / 2

medianGMoulds = testGeometric(mouldsPath)
medianGBacteria = testGeometric(bacteriaPath)
dustG = (medianGBacteria + medianGMoulds) / 2

medianSatMoulds = testSaturation(mouldsPath)
medianSatBacteria = testSaturation(bacteriaPath)
dustSat = (medianSatMoulds + medianSatBacteria) / 2

medianHSVMoulds = testMean(mouldsPath)
medianHSVBacteria = testMean(bacteriaPath)
dustHSV = (medianHSVBacteria + medianHSVBacteria) / 2

classify(photosPath)

#photos = readImages(photosPath)

# # RGB mean, std
# index = 1
# for image in photos:
#     result = extractRGBMeanStd(image)
#     mean = result[0]
#     std = result[1]
#     # if mean >= dustMean: print(f"{index}: B")
#     # elif mean < dustMean: print(f"{index}: M")
#     # else: print("nwm")
#
#     print(dustStd, std)
#     if std >= dustStd: print(f"{index}: M")
#     elif std < dustStd: print(f"{index}: B")
#     else: print("nwm")
#     index += 1

# # Sobel, Laplacel, entropia
# index = 1
# for image in photos:
#     result = extractTextureFeatures(image)
#     value = result[1]
#     # if value >= dustS: print(f"{index}: B")
#     # elif value < dustS: print(f"{index}: M")
#     # else: print("nwm")
#
#     # if value >= dustL: print(f"{index}: M")
#     # elif value < dustL: print(f"{index}: B")
#     # else: print("nwm")
#
#     # if value >= dustB: print(f"{index}: M")
#     # elif value < dustB: print(f"{index}: B")
#     # else: print("nwm")
#
#     index += 1

# # # geometric
# index = 1
# for image in photos:
#     result = extractGeometricFeatures(image)
#     value = result
#     if value >= dustG: print(f"{index}: M")
#     elif value < dustS: print(f"{index}: B")
#     else: print("nwm")
#
#     index += 1

# # Saturation
# index = 1
# for image in photos:
#     result = extractHSVSaturationArea(image)
#     value = result
#     if value >= dustSat: print(f"{index}: B")
#     elif value < dustSat: print(f"{index}: M")
#     else: print("nwm")
#
#     index += 1

# # HSV Mean
# index = 1
# for image in photos:
#     result = extractHSVMean(image)
#     value = result
#     if value >= dustHSV: print(f"{index}: B")
#     elif value < dustHSV: print(f"{index}: M")
#     else: print("nwm")
#
#     index += 1

