import glob
import json
from typing import List, Any


class Extractor:
    def __init__(self, base_directory_path: str):
        self.base_dir_path = base_directory_path
        self.generator = self._extract_next()

    def _extract_next(self):
        files = glob.glob(f'{self.base_dir_path}/**/*.java', recursive=True)
        for file in files:
            print(f"Extracted file: {file}")
            with open(file, 'r', encoding='utf-8') as java_file:
                yield '\n'.join(java_file.readlines())


    def extract(self, batch_size: int) -> List[str]:
        # print("Extracting next batch")
        batch = []
        for _ in range(batch_size):
            try:
                batch.append(next(self.generator))
            except StopIteration:
                break
        # print("Batch extracted")
        return batch

extractor_singleton = Extractor("./Sources")