<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>

    <section>
        <p>
            Zo všetkých strán nás obklopujú najrôznejšie informácie. Väčšina z nich má kvantitatívny charakter – vyjadrujú
            množstvá či poradie nejakých objektov, informujú nás o tvaroch, mierach a umiestení týchto objektov v priestore,
            informujú nás o rôznych veličinách a ich vzájomných vzťahoch. Od ich rýchleho spracovania, posúdenia a správneho
            vyhodnotenia mnohokrát záleží ako sa rozhodneme a to nielen v takej banálnej veci kde a čo nakúpiť, ale aj v
            takých závažných rozhodnutiach ako napr. - v akej oblasti sa budeme vzdelávať, aké povolanie si chceme vybrať,
            ako máme naložiť so svojimi financiami, prečo, ako a kde sa máme poistiť.
        </p>
    </section>

    <section>

        <h3>Ako zapisujeme čísla</h3>
        <p>
            V tejto časti si budeme všímať ako narábať s informáciami, ktoré majú číselnú podobu. Pozrime sa najprv na čísla,
            ktoré vyjadrujú <b>počet</b> objektov v (konečných) skupinách objektov. Tieto čísla voláme <b>prirodzené čísla.</b>
        </p>

        <p>
            Dobre si všimnite nasledujúce riadky obrázkov:
        <div class="center2"><img src="photo/p9.PNG" alt="obrazky"></div>
        </p>

        <p>
            Čo majú spoločné?
        </p>

        <p>
            Ak odhliadneme od toho, že všetky boli nakreslené pomocou programu LogoMotion, tak ich jedinou spoločnou
            vlastnosťou je <b>počet</b> zobrazených objektov. V každom riadku sú zobrazené <b>štyri</b> objekty.
        </p>

        <p>
            Schopnosť <b>počítať</b>, t. j. priradiť skupine objektov ich <b>počet</b>, je asi rovnako stará ako homo
            sapiens. Zároveň so vznikom písma začala aj história záznamu čísel v písomnej podobe
            <b><sup><dfn title="O histórii počítania sa môžete dozvedieť veľa zaujímavého v knihe:
                                                John D. Barrow : Pí na nebesích (Pi in the Sky).">[1]</dfn>
                </sup></b>.
        </p>

        <p>
            Prvé záznamy nejakej číselnej hodnoty sú známe už z obdobia lovcov mamutov. Sú to vrypy na rôznych kostiach a
            pripomínajú záznam na podložke pod pivovým pohárom, ktorým si čašník označuje počet pív, ktoré hostia pri danom
            stole vypili:
        <div class="center2"><img src="photo/p10.PNG" alt="vrypy na kostiach"></div>
        </p>

        <p>
            Čašník používa dve „číslice“ 卌 pre číslo 5 a <b>⎸</b>pre číslo 1. Ak chce napísať číslo dvadsaťsedem,
            použije päť symbolov pre číslo 5 a dva symboly pre číslo 1.
            Takémuto spôsobu zápisu sa hovorí <b>aditívny</b>. Podobne zapisovali čísla v starom Egypte. Mali zvláštne symboly
            pre mocniny desiatky:
        <div class="center2"><img src="photo/p2.png" alt="vrypy na kostiach"></div>
        </p>

        <p>
            Ak chceli napísať napr. $\pmb{276}$ urobili to takto:
        <div class="center2"><img src="photo/p3.png" alt="vrypy na kostiach"></div>
        </p>

        <p>
            Podobne postupovali Rimania, ktorí by to isté číslo zapísali ako $\pmb{CCLXXVI}$. Že rímsky (a každý aditívny)
            zápis čísel je nevýhodný, ak chceme robiť s číslami nejaké operácie, spoznáte pri riešení nasledujúceho príkladu.
        </p>
        <div class="priklad">
            <h3>Príklad 1.</h3>

            <p>
                Na hrobe jedného básnika je napísané: $\bf{^* MDCCCXCI \: \dagger \: MCMLXXXIX}$. Koľko rokov žil?
            </p>

            <h3>Riešenie:</h3>

            <p>
                Najprv v rímskom zápise oddeľme od seba skupiny symbolov, ktoré označujú jedno číslo, potom tieto prepíšeme
                "našim" spôsobom a sčítame:

                $M \, D \, C \, C \, C \, XC \, I = 1000 + 500 + 100 + 100 + 100 + 90 + 1 = 1981$<br>
                $M \, CM \, L \, X \, X \, X \, IX = 1000 + 900 + 50 + 10 + 10 + 10 + 9 = 1989$
            </p>

            <p>
                Jednoduchým odčítaním zistíme, že básnik žil $1989 - 1891 = 98$ rokov.
            </p>
        </div>


        <p>
            <details class="detailABACUS">
                <summary class="summaryABACUS"><b>Ako tú istú úlohu riešil rímsky žiačik
                        (asi pomocou počítadla).</b></summary>

        <p><h2>Rímsky zápis čísiel</h2></p>
        <p><mark>V rímskom systéme sa okrem základných symbolov M, D, C, L, X, V, I
                používali aj "zložené" symboly preto zápis väčších čísel a najmä operácie s nimi boli neprehľadné.
                Po premenení našich čísel len na základné symboly dostávame:</mark></p>
        $$
        \begin{array}{|c|c|c|c|c|}
        \hline & \cellcolor{cyan} \bf{Menšenec} & \cellcolor{lightblue} \bf{Upravený \, menšenec} &
        \cellcolor{#00FF00} \bf{Menšiteľ} & \cellcolor{red} \bf{Rozdiel}\\
        \hline & \cellcolor{cyan} MCMLXXXIX &\cellcolor{lightblue}  & \cellcolor{#00FF00}MDCCCXCI &\cellcolor{red} \\
        \hline Tisícky & \cellcolor{cyan}M & \cellcolor{lightblue}M & \cellcolor{#00FF00}M &\cellcolor{red} - \\
        \hline Päťstovky & \cellcolor{cyan}D & \cellcolor{lightblue}D & \cellcolor{#00FF00}D &\cellcolor{red} - \\
        \hline Stovky & \cellcolor{cyan}C,C,C,C & \cellcolor{lightblue}C,C,C & \cellcolor{#00FF00}C,C,C &\cellcolor{red} - \\
        \hline Päťdesiatky & \cellcolor{cyan}L & \cellcolor{lightblue}L,L &\cellcolor{#00FF00} L &\cellcolor{red} L \\
        \hline Desiatky & \cellcolor{cyan}X,X,X & \cellcolor{lightblue}X, X, X, X, X, X, X, X & \cellcolor{#00FF00}X,X,X,X
        &\cellcolor{red} X,X,X,X \\
        \hline Päťky & \cellcolor{cyan}V & \cellcolor{lightblue}V & \cellcolor{#00FF00}- &\cellcolor{red} V \\
        \hline Jednotky & \cellcolor{cyan}I, I, I, I & \cellcolor{lightblue}I, I, I, I, &\cellcolor{#00FF00} I &
        \cellcolor{red} I,I,I \\
        \hline
        \end{array}
        $$
        </details>
        </p>

        <p>
            Výrazne "modernejší" bol systém, ktorý používali v Babylone. Mali zvláštne symboly pre čísla od $1$ do $59$
            (zložené zo symbolov pre jednotku a desiatku):

        <div class="center2"><img src="photo/p4.png" alt="obrazky"></div>

        </p>

        <p>
            V ich systéme však hrala významnú úlohu pri zápise čísla nielen samotná číslica reprezentujúca určité číslo,
            ale aj <b>pozícia</b>, na ktorej bola táto číslica napísaná.
        <div class="center2"><img src="photo/p5.png" alt="obrazky"></div>
        </p>

        <p>
            Zápisom na tomto obrázku neoznačovali číslo $\bf{1 + 57 + 46 + 40}$, ale číslo
            $\bf{1 \cdot 60^3 + 57 \cdot 60^2 + 46 \cdot 60 + 40}$, čo je v našej desiatkovej sústave $\bf{424 \, 000}$.
        </p>

        <p>
            Ak odhliadneme od počtu "jednociferných" čísel (v Babylone ich mali 60) bola ich číselná sústava rovnaká ako
            naša.
        </p>
    </section>

    <div class="pagination">
        <a href="A11_6.php">&laquo;</a>
        <a class="active" href="A11_1.php">1</a>
        <a href="A11_2.php">2</a>
        <a href="A11_3.php">3</a>
        <a href="A11_4.php">4</a>
        <a href="A11_5.php">5</a>
        <a href="A11_6.php">6</a>
        <a href="A11_2.php">&raquo;</a>
    </div>

</div>
</div>

</body>
<?php
include('footer.html')
?>
</html>
