<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>
    <section>
        <h3>V čom spočíva výhodnosť nášho zápisu čísel?</h3>

        <p>
            Náš spôsob zápisu prirodzených čísel sa volá <b>pozičná číselná sústava so základom desať</b>. To znamená, že:

        <ul>
            <li>
                máme číslice (cifry) pre čísla nula, jeden, dva, ... atď. až deväť,
            </li>

            <li>
                vo viaccifernom zápise jednotlivé číslice predstavujú rôzne čísla (presnejšie rôzne násobky mocnín
                desiatky), v závislosti od ich pozície.
            </li>
        </ul>
        </p>

        <p>
            Jednoducho povedané, napríklad $\bf{1939 = 1 \cdot 10^3 + 9 \cdot 10^2 + 3 \cdot 10^1 + 9 \cdot 10^0}$.
        </p>

        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                V trojkovej číselnej sústave máme dané číslo $\bf{č = (\bar 2 \bar 1 \bar 0 \bar 2 \bar 1 \bar 0 \bar 0
                \bar 1)_3}$. Napíšte ho v sedmičkovej sústave.
            </p>

            <h3>Riešenie:</h3>

            <p>
                Vieme, že
                $$\bf{č = 2 \cdot 3^7 + 1 \cdot 3^6 + 0 \cdot 3^5 + 2 \cdot 3^4 + 1 \cdot 3^3 + 0 \cdot 3^2
                + 0 \cdot 3^1 + 1 \cdot 3^0 \qquad(V)}$$


                Ak tento zápis <b>vhodne<sup><dfn title="Vhodnosť spočíva v tom, že kým na výpočet hodnoty výrazu (V)
        potrebujeme 14 násobení, na výpočet hodnôt výrazu (H) len 7 násobení.">[2]</dfn></sup></b> upravíme, dostaneme:
                $$\bf{č = (((((((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 1 \qquad(H)}$$
            </p>

            <p>
                Vidíme tu sústavu do seba uzavretých zátvoriek. Pre lepšiu orientáciu napíšeme obsahy týchto zátvoriek od
                najvnútornejšej až po celý výraz:

                $$\begin{align}
                &\bf{(0) \qquad 2} \\
                &\bf{(1) \qquad (2) \cdot 3 + 1} \\
                &\bf{(2) \qquad ((2) \cdot 3 + 1) \cdot 3 + 0} \\
                &\bf{(3) \qquad (((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2} \\
                &\bf{(4) \qquad ((((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2) \cdot 3 + 1} \\
                &\bf{(5) \qquad (((((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2) \cdot 3 + 1) \cdot 3 + 0} \\
                &\bf{(6) \qquad ((((((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 0} \\
                &\bf{(7) \qquad (((((((2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 2) \cdot 3 + 1) \cdot 3 + 0) \cdot 3 + 0)
                \cdot 3 + 1}
                \end{align}$$
            </p>

            <p>
                Vidíme, že obsah nultej zátvorky je prvá číslica daného čísla a že obsah ľubovoľnej zátvorky dostaneme tak, že
                obsah predchádzajúcej vynásobíme základom $\bf{3}$ a pripočítame ďalšiu číslicu. Tento spôsob zápisu nás
                inšpiruje vypočítať číslo $\bf{č}$ v desiatkovej sústave použitím vhodnej tabuľky takto:

                $$\begin{array}
                {|c|c|}
                \hline  & \bf{2} & \bf{1} & \bf{0} & \bf{2} & \bf{1} & \bf{0} & \bf{0} & \bf{1}\\

                \hline \bf{3} & 2 & 7 & 21 & 65 & 196 & 588 & 1764 & \cellcolor{yellow} 5293\\

                \hline
                \end{array}$$
            </p>

            <p>
                V hornom riadku tabuľky<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Horner/" target="_blank">
                        <dfn title="Takáto tabuľka sa nazýva Hornerova schéma. William George Horner.">3</dfn>]</a></sup>
                sú cifry daného čísla, t.j. koeficienty pri mocninách základu číselnej sústavy a v
                druhom riadku sú hodnoty výrazov $(0)$ až $(7)$.
            </p>

            <p>
                Naša úloha bude doriešená, ak číslo $\bf{č}$ napíšeme v takom tvare ako je v riadku $\bf{(7)}$, ale miesto
                trojky tam bude všade sedmička.
            </p>

            <p>
                Všimnime si riadok $\bf{(7)}$ bližšie. Posledné číslo je zvyšok pri delení čísla $\bf{č}$ tromi, neúplný podiel
                je vlastne riadok $\bf{(6)}$. Posledné číslo v ňom (t.j. predposledná cifra čísla $\bf{č}$ zapísaného v
                trojkovej sústave) je zvyšok pri delení riadku $\bf{(6)}$ tromi. Kopírovaním tohto postupu pre sedmičku
                dostávame:

                $$\bf{č = 5293 = (756) \cdot 7 + 1 = ((108) \cdot 7 + 0) + 1 =}$$

                $$\bf{(((15) \cdot 7 + 3) \cdot 7 + 0)  \cdot 7 + 1 =
                ((((2) \cdot 7 + 1) \cdot 7 + 3) \cdot 7 + 0) \cdot 7 + 1}$$

            <ol>takže</ol>

            $$\bf{č = (\bar 2 \bar 1 \bar 3 \bar 0 \bar 1)_7}$$
            </p>
        </div>

        <p>
        <h3><mark>Poznámka:</mark></h3>


        Prevod čísla $\bf{č}$ z trojkovej do desiatkovej sústavy, aj spätný výpočet cifier čísla $\bf{č}$ v sedmičkovej
        sústave sme urobili v GeoGebre.
        Pozrite zošity:<br>
        <details class="detail">
            <summary class="summary"><b>Prevody.</b></summary><div class="center2">
                <iframe scrolling="no" title="A1.02" src="https://www.geogebra.org/material/iframe/id/emsepjf2/width/1200/height/700/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="700px" style="border:0px;"> </iframe>
            </div></details>
        <br>
        <details class="detail">
            <summary class="summary"><b>Prevody2.</b></summary><div class="center2">
                <iframe scrolling="no" title="A1.03" src="https://www.geogebra.org/material/iframe/id/x6kxw8n5/width/1200/height/700/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="700px" style="border:0px;"> </iframe>
            </div></details>
        </p>

        <p>
            Ďalšie podrobnosti z histórie o zapisovaní prirodzených čísel nájdete na stránkach:
        <ol><a href="https://mathshistory.st-andrews.ac.uk/HistTopics/Greek_numbers/" target="_blank">
                https://mathshistory.st-andrews.ac.uk/HistTopics/Greek_numbers/</a> </ol>
        <ol><a href="https://mathshistory.st-andrews.ac.uk/" target="_blank">
                https://mathshistory.st-andrews.ac.uk/</a></ol>
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>

            <ol>
                <li>
                    <p>
                        V číselnej sústave so základom $\bf{b}$ potrebujeme na identifikáciu čísiel menších ako $\bf{n}$ číslice
                        pre čísla $\bf{0, 1, ...}$ až $\bf{b - 1}$ a tiež názvy pre čísla $\bf{b^1, b^2, ...}$ t.j. pre mocniny
                        základu $\bf{b}$ neprevyšujúce číslo $\bf{n}$. Napríklad pre $\bf{n = 1000000}$ v desiatkovej sústave
                        potrebujeme $\bf{10}$ číslic a názvy pre čísla $\bf{10, 100, 1000, 10000}$ a $\bf{100000}$ spolu teda
                        <b>15 symbolov</b>.
                    </p>

                    <p>
                        Nájdite taký základ $\bf{b}$, pri ktorom potrebujeme na zápis čísiel do $\bf{1000000}$ najmenej symbolov.
                        (Riešenie nájdete v U01.)
                    </p>
                    <details class="detail">
                        <summary class="summary"><b>Riešenie.</b></summary>
                        <p id="sb4gj5m8"></p>
                    </details>
                </li>

                <li>
                    <p>
                        Koľkociferné bude číslo vyjadrujúce číslo $\bf{n}$ v číselnej sústave so základom $\bf{b}$?
                    </p>
                </li>

                <li>
                    <p>
                        Napíšte číslo $\bf{\frac{b^{10} - 1}{b - 1}}$ v pozičnej sústave so základom $\bf{b}$.
                        ($\bf{2 \leq b \leq 10}$)
                    </p>
                </li>

                <li>
                    <p>
                        Napíšte číslo $\bf{1 + b^2 + b^4 + b^6 + b^8}$ <b>v číselnej sústave</b>
                        <ol type="a">
                            <li>
                    <p>
                        so základom $\bf{b^2}$
                    </p>
                </li>

                <li>
                    <p>
                        so základom $\bf{b}$
                    </p>
                </li>
            </ol>
            </p>
            </li>


            </ol>
        </div>
    </section>
    <div class="pagination">
        <a href="A11_1.php">&laquo;</a>
        <a href="A11_1.php">1</a>
        <a class="active" href="A11_2.php">2</a>
        <a href="A11_3.php">3</a>
        <a href="A11_4.php">4</a>
        <a href="A11_5.php">5</a>
        <a href="A11_6.php">6</a>
        <a href="A11_3.php">&raquo;</a>
    </div>




</div>
</div>
</body>
<script>
    parameters={"material_id":"sb4gj5m8", "width":"1000"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('sb4gj5m8');
    };

</script>
<?php
include('footer.html')
?>
</html>
