<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>
    <section>
        <h3>Sčitovanie a násobenie</h3>

        <p>
            Spomínate ako ste sa na základnej škole učili sčitovať a násobiť? Základom boli tzv. "<b>sčítalka</b>" a
            "<b>malá násobilka</b>". Presnejšie, najprv ste sa naučili <b>spamäti</b> obsah týchto tabuliek:

            $$\begin{array}
            {|c|c|}
            \hline \cellcolor{red}\bf{+} & \bf{1} & \bf{2} & \bf{3} & \bf{4} & \bf{5} & \bf{6} & \bf{7} & \bf{8} & \bf{9} &
            &ensp; & \cellcolor{red}\bf{\times} & \bf{1} & \bf{2} & \bf{3} & \bf{4} & \bf{5} & \bf{6} & \bf{7} & \bf{8} & \bf{9}\\

            \hline \bf{1} & 2 & 3 & 4 & 5 & 6 & 7 & 8 & 9 & 10 & & \bf{1} & 1 & 2 & 3 & 4 & 5 & 6 & 7 & 8 & 9 \\
            \hline \bf{2} & 3 & 4 & 5 & 6 & 7 & 8 & 9 & 10 & 11 & & \bf{2} & 2 & 4 & 6 & 8 & 10 & 12 & 14 & 16 & 18 \\
            \hline \bf{3} & 4 & 5 & 6 & 7 & 8 & 9 & 10 & 11 & 12 & & \bf{3} & 3 & 6 & 9 & 12 & 15 & 18 & 21 & 24 & 27 \\
            \hline \bf{4} & 5 & 6 & 7 & 8 & 9 & 10 & 11 & 12 & 13 & & \bf{4} & 4 & 8 & 12 & 16 & 20 & 24 & 28 & 32 & 36 \\
            \hline \bf{5} & 6 & 7 & 8 & 9 & 10 & 11 & 12 & 13 & 14 & & \bf{5} & 5 & 10 & 15 & 20 & 25 & 30 & 35 & 40 & 45 \\
            \hline \bf{6} & 7 & 8 & 9 & 10 & 11 & 12 & 13 & 14 & 15 & & \bf{6} & 6 & 12 & 18 & 24 & 30 & 36 & 42 & 48 & 54 \\
            \hline \bf{7} & 8 & 9 & 10 & 11 & 12 & 13 & 14 & 15 & 16 & & \bf{7} & 7 & 14 & 21 & 28 & 35 & 42 & 49 & 56 & 63 \\
            \hline \bf{8} & 9 & 10 & 11 & 12 & 13 & 14 & 15 & 16 & 17 & & \bf{8} & 8 & 16 & 24 & 32 & 40 & 48 & 56 & 64 & 72 \\
            \hline \bf{9} & 10 & 11 & 12 & 13 & 14 & 15 & 16 & 17 & 18 & & \bf{9} & 9 & 18 & 27 & 36 & 45 & 54 & 63 & 72 & 81 \\
            \hline
            \end{array}$$
        </p>

        <p>
            Aby ste vedeli sčítať, alebo vynásobiť väčšie čísla, naučili ste sa tzv. "<b>písomné sčitovanie</b>" a
            "<b>písomné násobenie</b>". Pripomeňme si to na príkladoch:
        </p>

        <div class="priklad">
            <h3>Príklad 3.</h3>

            <p>
                <b>Písomné sčitovanie (dvoch čísel) v pozičnej číselnej sústave so základom </b> $\bf{10}$.

                $$\begin{array}
                {cc}
                \bf{n1 = } & \bf{1} & \bf{8} & \bf{3} & \bf{8} & \bf{2} & \bbox[cyan, 2pt]{\bf{8}} & \bf{0} & \bf{5}\\
                \bf{n2 =} & & & \bf{6} & \bf{5} & \bf{0} & \bbox[cyan, 2pt] {\bf{6}} & \bf{1} & \bf{5}\\
                \hline n1 + n2 = & 1 & 9 & 0 & 3 & 3 & \bbox[yellow, 2pt] 4 & 2 & 0\\
                \bf{zostalo} & \bf{0} & \bf{0} & \bf{1} & \bf{1} & \bf{0} & \bbox[red, 2pt]{\bf{1}} & \bbox[cyan, 2pt]{\bf{0}}
                & \bf{1}
                \end{array}$$
            </p>

            <p>
                Žlté číslo je <b>zvyšok</b> po vydelení súčtu modrých čísel desiatimi a červené číslo je celá časť tohto podielu.
                Konkrétne:

                $$\begin{array}{cc}
                \bf{0 + 6 + 8 = 14} & & \bbox[cyan, 2pt]{\bf{14}} & \bf{:} & \bf{10} & \bf{=} & \bbox[red, 2pt]{\bf{1}}\\
                && &ensp; \bbox[yellow, 2pt]4\\
                \end{array}$$
            </p>

            <p>
                Keby sme mali iný základ číselnej sústavy ako $10$, napr. $5$, tabuľky pre sčitovanie a násobenie by vyzerali
                takto:

                $$\begin{array}
                {|c|c|}
                \hline \cellcolor{red}\bf{+} & \bf{1} & \bf{2} & \bf{3} & \bf{4} & &ensp; &
                \cellcolor{red}\bf{\times} & \bf{1} & \bf{2} & \bf{3} & \bf{4} \\

                \hline \bf{1} & 2 & 3 & 4 & 10 & & \bf{1} & 1 & 2 & 3 & 4 \\
                \hline \bf{2} & 3 & 4 & 10 & 11 & & \bf{2} & 2 & 4 & 11 & 13 \\
                \hline \bf{3} & 4 & 10 & 11 & 12 & & \bf{3} & 3 & 11 & 14 & 22 \\
                \hline \bf{4} & 10 & 11 & 12 & 13 & & \bf{4} & 4 & 13 & 22 & 31 \\
                \hline
                \end{array}$$
            </p>
        </div>

        <p>
            Myslím si, že takúto "sčítalku" a malú násobilku by zvládol každý prváčik.
        </p>

        <p>
            Ako by vyzerala "sčítalka" a malá násobilka v ľubovoľnej pozičnej sústave so základom $\bf{b}$, si môžete
            pozrieť v 1. hárku excelovského zošitu +a*. Ako by sa sčitovali dve viacciferné čísla, si môžete pozrieť v 2.
            hárku toho istého zošitu.
        </p>

        <details class="detail">
            <summary class="summary"><b>Ako by vyzerala "sčítalka" a malá násobilka v ľubovoľnej pozičnej sústave so
                    základom $\bf{b}$.</b></summary>
            <iframe scrolling="no" title="A1.05a" src="https://www.geogebra.org/material/iframe/id/shyn6mc5/width/1400/height/800/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1400px" height="800x" style="border:0px;"> </iframe>
        </details>
        <br>
        <details class="detail">
            <summary class="summary"><b>Ako by sa sčitovali dve viacciferné čísla.</b></summary>

            <iframe scrolling="no" title="A1.05 b" src="https://www.geogebra.org/material/iframe/id/jnx3c48g/width/1200/height/937/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="937px" style="border:0px;"> </iframe>
        </details>




        <p>
            Podobne to bolo s násobením. Najprv sme sa naučili násobiť jednociferným číslom:
        </p>

        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Písomné násobenie viacciferného čísla jednociferným v pozičnej číselnej sústave so základom $b, (2 \leq b \leq 10)$.

                $$
                \begin{array}{cc}
                \bf{b = 5} & &emsp; & &emsp; & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 3 & 4 & & \times & & 4 \\ \hline
                && \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{3} & \bf{0} & \bf{1}\\
                \color{blue}\bf{zostalo} & & \color{blue}\bf{0} & \color{blue}\bf{0} & \color{blue}\bf{0} & \color{blue}\bf{0}
                & \color{blue}\bf{0} & \color{blue}\bf{0} & \color{blue}\bf{0} & \color{blue}\bf{0} & \color{blue}\bf{0}
                & \color{blue}\bf{3} & \color{blue}\bf{3}
                \end{array}
                $$
            </p>

            <p>
                Asi najväčšou prednosťou zápisu čísel v pozičnej sústave je možnosť jednoduchého písomného násobenia
                viacciferným súčiniteľom. Ak už vieme násobiť číslo $\bf{a}$ jednocifernými činiteľmi, tak ak ho máme vynásobiť
                napr. číslom $\bf{(\bar{c}_3, \bar{c}_2, \bar{c}_1, \bar{c}_0)_b}$, postupujeme takto:


                $$\bf{a \cdot (\bar{c}_3, \bar{c}_2, \bar{c}_1, \bar{c}_0)_b =}$$
                $$\bf{a \cdot (c_3 \cdot b^3 + c_2 \cdot b^2 + c_1 \cdot b^1 + c_0 \cdot b^0) =}$$
                $$\bf{a \cdot c_3 \cdot b^3 + a \cdot c_2 \cdot b^2 + a \cdot c_1
                \cdot b^1 + a \cdot c_0 \cdot b^0} \qquad(^*)$$

                keďže násobiť číslom $\bf{b}$ (t.j. základom pozičnej sústavy) znamená len pridať ako poslednú cifru nulu (resp.
                posunúť celý zápis čísla o jedno miesto doľava), má písomné násobenie tvar, ktorý si pamätáme z lavíc základnej
                školy.
            </p>
        </div>
        <p>
            Menej typický vyzerá takýto zápis v inej ako dekadickej sústave:
        </p>

        <div class="priklad">
            <h3>Príklad 5</h3>

            <p>
                Písomné násobenie viacciferného čísla viacciferným číslom v pozičnej číselnej sústave so základom 2:

                $$\begin{array}
                {cc}
                & 0 & 0 & 0 & 0 & 0 & 1 & 1 & 1 & 1 & 1 & &ensp; & \times & &ensp; & 0 & 1 & 1 & 1 \\
                \hline \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} \\
                & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{1} & \bf{1} & \bf{1} & \bf{1} & \bf{1} \\
                &&& \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{1} & \bf{1} & \bf{1} & \bf{1} & \bf{1} \\
                &&&&& \bf{0} & \bf{0} & \bf{0} & \bf{0} & \bf{1} & \bf{1} & \bf{1} & \bf{1} & \bf{1} \\
                \hline 0 & 0 & 0 & 0 & 0 & 0 & 1 & 1 & 0 & 1 & 1 & 0 & 0 & 1
                \end{array}$$
            </p>
        </div>

        <p>
            Používanie dvojkovej pozičnej číselnej sústavy má:
        <ul>
            <li>
                výhodu v tom, že "sčítalka" aj malá násobilka sú minimálne
            </li>

            <li>
                nevýhodu v tom, že potrebujeme vykonávať veľký počet základných operácií.
            </li>

        </ul>

        V prípade počítačov prevážila výhoda nad nevýhodou.
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="5">
                <li>
                    <p>
                        Skontrolujte správnosť násobenia v poslednej ukážke tým spôsobom, že prevediete oba súčinitele aj súčin
                        do dekadickej sústavy.
                    </p>
                </li>

                <li>
                    <p>
                        Otvorte si Hárok 3, dobre si ho pozrite a v Hárku 4 dorobte tabuľku pre násobenie
                        viacciferným číslom v číselnej sústave so základom $b, 1 \lt b \leq 10$. Ak sa Vám to nepodarí, pozrite
                        si Hárok 5.
                    </p>
                </li>

                <details class="detail">
                    <summary class="summary"><b>Hárok 3.</b></summary>
                    <iframe scrolling="no" title="A1.05 c" src="https://www.geogebra.org/material/iframe/id/syr9pdfs/width/1350/height/700/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="700px" style="border:0px;"> </iframe>
                </details>

                <details class="detail">
                    <summary class="summary"><b>Hárok 4.</b></summary>
                    <iframe scrolling="no" title="A1.05 d" src="https://www.geogebra.org/material/iframe/id/h8aszwbn/width/1350/height/600/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="600px" style="border:0px;"> </iframe>
                </details>

                <details class="detail">
                    <summary class="summary"><b>Hárok 5.</b></summary>
                    <iframe scrolling="no" title="A1.05e" src="https://www.geogebra.org/material/iframe/id/us2hqvx9/width/1350/height/600/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="600px" style="border:0px;"> </iframe>
                </details>
            </ol>
        </div>

        <p>
        <h3><mark>Poznámka</mark></h3>

        Zamyslime sa nad rovnosťou $(^*)$ z predchádzajúcej strany. Úplne samozrejme sme tam použili takúto vlastnosť
        sčitovania a násobenia prirodzených čísel: <br>
        $\bf{\forall a, b, c \in N : a \cdot (b + c) = a \cdot b + b \cdot c}$, ktorú voláme <b>distributívnosť
            násobenia vzhľadom na sčitovanie</b> (ak jeden činiteľ súčinu je súčtom viacerých sčítancov, môžeme násobenie
        rozdeliť (distribuovať) na jednotlivé sčítance).
        </p>

        <p>
            Podobne používame vlastnosti<sup><dfn title="Spoločnými vlastnosťami sčitovania, násobenia, rovnosti
                                    a usporiadania čísel podľa veľkosti sa budeme zaoberať v závere kapitoly o číslach.">[4]</dfn></sup>:

            $$\begin{array}{cc}
            \bf{\forall a, b, c \in N : a + (b + c) = (a + b) + c} & \bf{\forall a, b, c \in N: a \cdot (b \cdot c) =
            (a \cdot b) \cdot c} & \bf{asociatívnosť} \\
            \bf{\forall a, b \in N : a + b = b + a} & \bf{\forall a, b \in N: a \cdot b = b \cdot a} & \bf{komutatívnosť}
            \end{array}$$
        </p>

        <p>
            Všetky vlastnosti prirodzených čísel sa dajú odvodiť z tzv. <b>Peanových axióm</b><sup>[
                <a href="https://mathshistory.st-andrews.ac.uk/Biographies/Peano/" target="_blank">
                    <dfn title="Giuseppe Peano.
                                    1. Jednotka je prirodzené číslo.
                                    2. Každé číslo má svojho nasledovníka.
                                    3. Jednotka nie je nasledovníkom žiadneho prirodzeného čísla.
                                    4. Každé číslo je nasledovníkom najviac jedného čísla.
                                    5. Každá množina, ktorá obsahuje jednotku a s každým svojim prvkom aj jeho nasledovníka,
                                    obsahuje celú množinu prirodzených čísel.">5</dfn></a>]</sup></p>

    </section>
    <div class="pagination">
        <a href="A11_2.php">&laquo;</a>
        <a href="A11_1.php">1</a>
        <a href="A11_2.php">2</a>
        <a class="active" href="A11_3.php">3</a>
        <a href="A11_4.php">4</a>
        <a href="A11_5.php">5</a>
        <a href="A11_6.php">6</a>
        <a href="A11_4.php">&raquo;</a>
    </div>



</div>
</div>
</body>
<?php
include('footer.html')
?>
</html>
