<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>
    <section>
        <h3>Deliteľnosť <sup><dfn title="Myslíme deliteľnosť v obore prirodzených čísel.">[6]</dfn></sup> </h3>

        <p>
            Na bankete v jednej ZOO vznikla diskusia o tom, kedy treba oslavovať tzv. okrúhle výročia. Opice boli za násobky
            čísla desať, lebo mali na každej ruke po päť prstov, sliepky navrhovali ako okrúhle výročia násobky čísla šesť,
            lebo u nich má každá po troch prstoch na oboch nohách a pochopiteľne používajú pozičnú číselnú sústavu so
            základom šesť, kone navrhovali dvojkovú sústavu, lebo na oboch predných nohách majú po jednom kopyte. Nakoniec
            sa dohodli (aj vzhľadom na to, že o slovo sa hlásili aj pavúky a stonožky), že <b>výnimočnosť</b> čísla nebude
            závisieť od používanej číselnej sústavy.
        </p>

        <p>
            Pri hľadaní vhodného návrhu využime známy fakt, že niektoré čísla sú násobkami iných. Napríklad číslo $66$ sa dá
            napísať ako:

            $$66 = 1 \cdot 66 = 2 \cdot 33 = 6 \cdot 11$$
        </p>

        <p>
            Hovoríme, že $66$ je <b>násobkom</b> čísiel $1, 2, 3, 6, 11, 22, 33, 66$, alebo tiež, že čísla $1, 2, 3, 6, 11,
            22, 33, 66$ sú <b>deliteľmi</b> čísla $66$.
        </p>

        <p>
            Dohodnime sa, že počet deliteľov čísla $\bf{n}$ budeme označovať symbolom $\bf{f(n)}$.
        </p>

        <p>
            Iste viete, že číslo $\bf{n}$ je <b>prvočíslom</b> práve vtedy, ak $\bf{f(n) = 2}$. Číslo $\bf{n}$ sa volá
            <b>zložené</b> práve vtedy, keď je $\bf{f(n) > 2}$. Ako uvidíte, <b>prvočísla sú skutočne výnimočné čísla</b>
        </p>

        <p>
            Koľko existuje prvočísel? Na túto otázku odpovedal už <b>Euklides</b>. Uvažoval asi takto<sup>[
                <a href="https://mathshistory.st-andrews.ac.uk/Biographies/Euclid/" target="_blank">
                    <dfn title="Euklides.
                                                Pozri tiež: Richard Courant and Herbert Robbins „What is mathematics?“">7</dfn></a>]</sup>:
        </p>

        <p>
            Keby bol počet prvočísel konečný, napríklad existovali by prvočísla $\bf{p_1, p_2, ... p_n}$, potom číslo
            $\bf{p_1 \cdot p_2 \cdot ... p_n + 1}$ nie je prvočíslom, lebo je väčšie od každého z prvočísel $\bf{p_i}$, ale
            nie je ani zloženým číslom, lebo nie je deliteľné žiadnym z prvočísel $\bf{p_i}$. Teda predpoklad, že prvočísel
            je konečný počet vedie ku sporu a preto je pravda, že počet prvočísel nie je konečný.
        </p>

        <p>
            Márne boli snahy nájsť nejaký vzorec, ktorý by vypočítal ako vyzerá v poradí podľa veľkosti $n-té$ prvočíslo.
            Márne boli aj snahy nájsť vzorec, ktorý by po dosadení ľubovoľného čísla $n$ dával ako výsledok prvočíslo.
        </p>

        <p>
            Prvočísla aj dnes svojim správaním sa vzbudzujú záujem matematikov. Zdanlivý chaos s akým sú rozložené medzi
            číslami, provokoval matematikov nájsť v tomto chaose nejaké zákonitosti. Hľadaním čo najväčších prvočísel sa
            testujú schopnosti nových počítačov<sup><dfn title="V júni 2004 bolo najväčšie známe prvočíslo 2^(24036583) - 1.">
                    [8]</dfn></sup>. Rozložiť skutočne veľké číslo na súčin dvoch prvočísel je natoľko obťažná úloha, že sa
            využíva pri kódovaní prenášaných správ<sup><dfn title="Pozri: Keith Devlin „Jazyk matematiky“ (Jak zviditelnit
                                                neviditelné)">[9]</dfn></sup>.
        </p>

        <p>
            Na vyhľadávanie prvočísel sa používali rôzne algoritmy. Prvý, ktorý sa stal známym sa volá Eratosténovo sito.
            Tento spôsob sa hodí len pre relatívne malé čísla.

            <details class="detail">
                <summary class="summary"><b>Eratosténovo sito</b></summary>
        <p id="ypvdfdgf"></p>
        </details>
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="7">
                <li>
                    <p>
                        Dobre si pozrite Excelovský zošit Delitele. Pokúste sa pomocou neho rozložiť ľubovoľné prirodzené číslo
                        menšie alebo rovné ako $1 000 000$ na súčin prvočísel. (Ak si nebudete vedieť poradiť, pozrite si v tom
                        zošite Hárok 2.)

                        <br><br><a href="excel/A1.07.xlsx" download="excel/A1.07.xlsx">
                            Delitele 1. hárok. - na stiahnutie
                        </a>

                        <details class="detail">
                            <summary class="summary"><b>Delitele 2. hárok</b></summary>
                            <iframe scrolling="no" title="A1.07 b" src="https://www.geogebra.org/material/iframe/id/db5dumzk/width/1000/height/400/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="400px" style="border:0px;"> </iframe>
                        </details>
                    </p>

                </li>

                <li>
                    <p>
                        Overte hypotézu: Súčet štvorcov dvoch za sebou idúcich prirodzených čísel je alebo deliteľnými piatimi,
                        alebo je prvočíslo. (Pozri Hypotéza.)

                        <details class="detail">
                            <summary class="summary"><b>Hypotéza - 1. hárok</b></summary>
                            <iframe scrolling="no" title="A1.08 a" src="https://www.geogebra.org/material/iframe/id/qeumv7rf/width/1350/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="500px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>

                <li>
                    <p>
                        Overte hypotézu: Hodnota výrazu $\bf{n^2 - 79n + 1601}$ je pre ľubovoľné prirodzené číslo $n$ rôzne
                        od čísla $\bf{1601}$ prvočíslom. (Pozrite si 2. hárok zošitu Hypotéza.)
                        <details class="detail">
                            <summary class="summary"><b>Hypotéza - 2. hárok</b></summary>
                            <iframe scrolling="no" title="A1.08 b" src="https://www.geogebra.org/material/iframe/id/pbbuj4ey/width/1350/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="600px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>

                <li>
                    <p>
                        V zošite Hádanie prvočísel si môžete tipovať prvočísla. Objasnite, ako dokáže počítač odpovedať na
                        položenú otázku. (Pozor na tajomné atramenty!)
                        <details class="detail">
                            <summary class="summary"><b>Hádanie prvočísel</b></summary>
                    <p id="apdsqqaj"></p>
                    </details>
                    </p>
                </li>

                <li>
                    <p>
                        Symbolom $\bf{A(n)}$ označujeme počet prvočísel neprevyšujúcich $n$. Na internete si nájdite hodnoty
                        tejto funkcie pre mocniny čísla $10$ a doplňte tabuľku v zošite A(n).
                        <details class="detail">
                            <summary class="summary"><b>A(n)</b></summary>
                            <iframe scrolling="no" title="A1.10" src="https://www.geogebra.org/material/iframe/id/ff2jeuw3/width/1200/height/650/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200x" height="650px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>
            </ol>
        </div>

        <p>
            Mnoho ďalších zaujímavých poznatkov o prvočíslach sa môžete dozvedieť na:<br>
            <a href="http://mathworld.wolfram.com/PrimeNumber.html">http://mathworld.wolfram.com/PrimeNumber.html</a><br>
            <a href="http://www.cut-the-knot.org/induction.shtml">http://www.cut-the-knot.org/induction.shtml</a>
        </p>

        <p>
            Postup, ktorý sme použili v hárku 2 zošitu Delitele, svedčí o tom, že každé prirodzené číslo (väčšie ako $1$) sa
            dá rozložiť na súčin prvočísiel<sup><dfn title="Toto tvrdenie sa nazýva základná veta aritmetiky.">[10]</dfn></sup>.
            Že sa to dá urobiť (až na poradie činiteľov) jediným spôsobom, dokázal už <b>Euklides</b>. Pri dôkaze použil jednoduchý
            algoritmus na výpočet <b>najväčšieho spoločného delitela dvoch čísel</b>.

            <details class="detail">
                <summary class="summary"><b>Delitele 2. hárok</b></summary>
                <iframe scrolling="no" title="A1.07 b" src="https://www.geogebra.org/material/iframe/id/db5dumzk/width/1000/height/400/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="400px" style="border:0px;"> </iframe>
            </details>

        </p>

        <p><mark>Hľadáme $\bf{N \cdot S \cdot D(A;B)}$.</mark></p>

        <p>
            <mark>Nech $\bf{A > B}$. Vydelíme číslo $\bf{A}$ číslom $\bf{B}$. $\bf{A = k_1 \cdot B + C}$, keďže $\bf{C = A – k_1
                \cdot B}$, tak každý spoločný deliteľ čísiel $\bf{A}$ a $\bf{B}$ je aj deliteľom čísla $\bf{C}$, navyše platí
                $\bf{C \lt B}$. Postup opakujeme, vydelíme číslo $\bf{B}$ číslom $\bf{C}$. $\bf{B = k_2 \cdot C + D}$, keďže
                $\bf{D = B – k_2 \cdot C}$, tak každý spoločný deliteľ čísiel $\bf{B}$ a $\bf{C}$ je aj deliteľom čísla $\bf{D}$,
                navyše platí $\bf{D \lt C}$.</mark>
        </p>

        <p>
            <mark>Takto dostávame klesajúcu postupnosť prirodzených čísel, ktorá je preto nutne konečná. Posledný nenulový zvyšok
                je hľadaným najväčším spoločným deliteľom. Pozrite si to v zošite Euklid.</mark>
            <details class="detail">
                <summary class="summary"><b>Euklid 1. hárok</b></summary>
                <iframe scrolling="no" title="A1.11 a" src="https://www.geogebra.org/material/iframe/id/gbqjdr4p/width/1200/height/650/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="650px" style="border:0px;"> </iframe>
            </details>
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="12">
                <li>
                    <p>
                        Zrejme viete, čo je to <b>najmenší spoločný násobok dvoch čísel</b>. Zostrojte (v 2. hárku zošitu Euklid)
                        postup na jeho určenie, ktorý bude fungovať obdobne ako postup na určenie najväčšieho spoločného deliteľa.
                        <details class="detail">
                            <summary class="summary"><b>Euklid 2. hárok</b></summary>
                            <iframe scrolling="no" title="A1.11 b" src="https://www.geogebra.org/material/iframe/id/jhu7ysux/width/1200/height/650/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="650px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>

                <li>
                    <p>
                        Navrhnite postupy na určenie najväčšieho spoločného deliteľa aj najmenšieho spoločného násobku $\bf{n}$
                        čísel (v 3. hárku zošitu Euklid).
                        <details class="detail">
                            <summary class="summary"><b>Euklid 3. hárok</b></summary>
                            <iframe scrolling="no" title="A1.11c" src="https://www.geogebra.org/material/iframe/id/w4pueyuq/width/1100/height/300/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1100px" height="300px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>
            </ol>
        </div><br>

        <div class="priklad">
            <h3>Príklad 6.</h3>

            <p>
                Dokážte, že pre každé prirodzené číslo $\bf{n}$ a každé prvočíslo $\bf{p}$  platí
                <sup><dfn title="Toto tvrdenie budeme neskôr potrebovať.">[10]</dfn></sup>:
                $$\bf{p / n^2 \Rightarrow p / n},$$ alebo slovami, ak prvočíslo $\bf{p}$ je deliteľom čísla $\bf{n^2}$, tak je
                aj deliteľom čísla $\bf{n}$.
            </p>

            <p>
                Skúsme predpokladať, že naše tvrdenie neplatí, t. j. že $\bf{p / n^2}$ , ale $\bf{n}$ nie je násobkom prvočísla
                $\bf{p}$. Potom v rozklade čísla $\bf{n}$ na prvočinitele sa prvočíslo $\bf{p}$ nenachádza, a preto sa nemôže
                nachádzať ani v rozklade čísla $\bf{n^2}$ čo je spor s tým, že  $\bf{p / n^2}$.
            </p>

        </div>

    </section>
    <div class="pagination">
        <a href="A11_3.php">&laquo;</a>
        <a href="A11_1.php">1</a>
        <a href="A11_2.php">2</a>
        <a href="A11_3.php">3</a>
        <a class="active" href="A11_4.php">4</a>
        <a href="A11_5.php">5</a>
        <a href="A11_6.php">6</a>
        <a href="A11_5.php">&raquo;</a>
    </div>

    <script>
        parameters={"material_id":"ypvdfdgf", "width":"1200", "height":"900"};
        var applet1 = new GGBApplet(parameters, '5.0', views);

        parameters={"material_id":"apdsqqaj", "width":"1350", "height":"600"};
        var applet5 = new GGBApplet(parameters, '5.0', views);

        window.onload = function() {
            applet1.inject('ypvdfdgf');
            applet5.inject('apdsqqaj');
        };

    </script>

</div>
</div>
</body>
<?php
include('footer.html')
?>
</html>
