<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>
    <section>

        <h3>Pytagorejské trojice<sup>[
                <a href="https://mathshistory.st-andrews.ac.uk/Biographies/Pythagoras/" target="_blank">
                    <dfn title="Pytagoras.">12</dfn></a>]</sup>.</h3>

        <div class="priklad">
            <h3>Príklad 7.</h3>

            <p>
                Nájdite všetky trojice $\bf{(a, b, c)}$ prirodzených čísel, pre ktoré platí: $\bf{a^2 + b^2 = c^2 \qquad (1)}$.
            </p>

            <p>
                Pomocou Excelu (pozri experiment) sme našli niekoľko trojíc:
                <details class="detail">
                    <summary class="summary"><b>Experiment 1. hárok</b></summary>
            <p id="cvqrfapy"></p>
            </details>
            <details class="detail">
                <summary class="summary"><b>Experiment 2. hárok</b></summary>
                <iframe scrolling="no" title="A1.12b" src="https://www.geogebra.org/material/iframe/id/byjjfm3b/width/1400/height/800/border/888888/sfsb/true/smb/true/stb/true/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1400px" height="800px" style="border:0px;"> </iframe>
            </details>

            $$\begin{array}
            {c|cc}
            a & \bbox[yellow, 2pt]{3} & \bbox[cyan, 2pt]{5} & \bbox[yellow, 2pt]{6} & \bbox[lime, 2pt]{7} &
            \bbox[magenta, 2pt]{8} & \bbox[yellow, 2pt]{9} & \bbox[cyan, 2pt]{10} & \bbox[yellow, 2pt]{12} &
            \bbox[yellow, 2pt]{15} & \bbox[yellow, 2pt]{18} & \bbox[red, 2pt]{20}\\
            b & \bbox[yellow, 2pt]{4} & \bbox[cyan, 2pt]{12} & \bbox[yellow, 2pt]{8} & \bbox[lime, 2pt]{24} &
            \bbox[magenta, 2pt]{15} & \bbox[yellow, 2pt]{12} & \bbox[cyan, 2pt]{24} & \bbox[yellow, 2pt]{16} &
            \bbox[yellow, 2pt]{20} & \bbox[yellow, 2pt]{24} & \bbox[red, 2pt]{21}\\
            c & \bbox[yellow, 2pt]{5} & \bbox[cyan, 2pt]{13} & \bbox[yellow, 2pt]{10} & \bbox[lime, 2pt]{25} &
            \bbox[magenta, 2pt]{17} & \bbox[yellow, 2pt]{15} & \bbox[cyan, 2pt]{26} & \bbox[yellow, 2pt]{20} &
            \bbox[yellow, 2pt]{25} & \bbox[yellow, 2pt]{30} & \bbox[red, 2pt]{29}\\
            \end{array}$$
            </p>

            <p>
                Riešenia podfarbené rovnakou farbou sa líšia len násobkom, žlté sú násobkami tzv. primitívnej trojice
                $\bf{(3, 4,5)}$, modré sú násobkami primitívnej trojice $\bf{(5, 12, 13)}$.
            </p>

            <p>
                Hľadanie všeobecného riešenia<sup><dfn title="Pozri: Richard Courant and Herbert Robbins „What is mathematics?“">[13]
                    </dfn></sup> je trošku „umelé“:
            </p>

            <p>
                Označme $\bf{\frac{a}{c} = x, \frac{b}{c} = y}$, potom rovnica $(1)$ dostáva podobu : $\bf{x^2 + y^2 = 1}$,
                alebo po úpravách postupne $\bf{y^2 = 1 - x^2, y^2 = (1 – x) \cdot (1 + x), \frac{y}{1+x} = \frac{1 - x}{y}}$,
                teda existuje taký zlomok $\bf{t = \frac{u}{v}}$, že platí : $\bf{\frac{y}{1 + x} = t}$ a
                $\bf{t = \frac{1 - x}{y}}$, alebo  $\bf{y = (1 + x) \cdot t, y \cdot t = 1 – x}$, po úprave máme 2 rovnice:
                $\bf{t \cdot x - y = -t, x + t \cdot y = 1}$ ich riešením je dvojica

                $$\bf{x = \frac{1 - t^2}{1 + t^2} = \frac{1 - \frac{u^2}{v^2}}{1 + \frac{u^2}{v^2}} = \frac{v^2 - u^2}{u^2 + v^2}
                = \frac{a}{c}, &ensp; y = \frac{2t}{1 + t^2} = \frac{\frac{2u}{v}}{1 + \frac{u^2}{v^2}} = \frac{2uv}{u^2 + v^2
                = \frac{b}{c}}}$$
            </p>

            <p>
                Z uvedeného vyplýva, že ak čísla $\bf{a, b, c}$ sú Pytagorejská trojka, tak existujú také celé čísla
                $\bf{k, u, v,}$ že:
                $$\bf{a = k \cdot (v^2- u^2), \, b = k \cdot 2uv, \, c = k \cdot (v^2 + u^2)}$$
            </p>

            <p>
                Aby sme dostali primitívne trojice, musíme voliť $\bf{k = 1}$ a čísla $\bf{u, v (v > u)}$ musia byť nesúdeliteľné,
                a pritom nie obe nepárne. (Príklady primitívnych trojíc nájdete v Experiment P.)
                <details class="detail">
                    <summary class="summary"><b>Experiment P - 1. hárok</b></summary>
                    <iframe scrolling="no" title="A1.13 a" src="https://www.geogebra.org/material/iframe/id/vbtahnse/width/1350/height/500/border/888888/sfsb/true/smb/true/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="500px" style="border:0px;"> </iframe>
                </details>
                <details class="detail">
                    <summary class="summary"><b>Experiment P - 2. hárok</b></summary>
                    <iframe scrolling="no" title="A1.13 b" src="https://www.geogebra.org/material/iframe/id/hj8gtgtb/width/1350/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="600px" style="border:0px;"> </iframe>
                </details>

                <details class="detail">
                    <summary class="summary"><b>Experiment P - 3. hárok</b></summary>
                    <iframe scrolling="no" title="A1.13c" src="https://www.geogebra.org/material/iframe/id/dbhnqkgc/width/1350/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1350px" height="600px" style="border:0px;"> </iframe>
                </details>
            </p>
        </div><br>


        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="14">
                <li>
                    <p>
                        Nájdite takú Pytagorejskú trojku $\bf{(a, b, c)}$ aby trojica čísel $\bf{(b, c, d)}$ bola tiež Pytagorejská.
                    </p>
                </li>

                <li>
                    <p>
                        Nájdite také Pytagorejské trojky $\bf{(a, b, c)}$ a $\bf{(b, d, e)}$, aby obsah trojuholníka so
                        stranami $\bf{c, a + d, e}$ bol čo najmenší.
                    </p>
                </li>
            </ol>

            <p>
                Pri riešení oboch úloh použite Excelovský súbor Experiment P.

            </p>
        </div>
    </section>
    <div class="pagination">
        <a href="A11_4.php">&laquo;</a>
        <a href="A11_1.php">1</a>
        <a href="A11_2.php">2</a>
        <a href="A11_3.php">3</a>
        <a href="A11_4.php">4</a>
        <a class="active" href="A11_5.php">5</a>
        <a href="A11_6.php">6</a>
        <a href="A11_6.php">&raquo;</a>
    </div>

    <script>
        parameters={"material_id":"cvqrfapy", "width":"1100", "height":"600"};
        var applet1 = new GGBApplet(parameters, '5.0', views);

        window.onload = function() {
            applet1.inject('cvqrfapy');


        };

    </script>

</div>
</div>
</body>
<?php
include('footer.html')
?>
</html>
