<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA11.html');
?>

<div class="item2">
    <h2>1.1 Prirodzené čísla</h2>
    <section>
        <h3>Dominový efekt (Princíp matematickej indukcie)</h3>

        <div class="priklad">
            <h3>Príklad 8.</h3>

            <p>
                Nájdite najväčšie prirodzené číslo $n$, pre ktoré je výraz $\bf{5 \cdot 4^n + 1}$ deliteľný číslom $\bf{3}$.
            </p>

            <h3>Riešenie:</h3>

            <p>
                Experiment hovorí, že pre prvých $\bf{10}$ prirodzených čísel to platí :

                $$\begin{array}{c|c}
                \bf{n} & \bf{1} & \bf{2} & \bf{3} & \bf{4} & \bf{5} & \bf{6} & \bf{7} & \bf{8} & \bf{9} & \bf{10} \\
                \hline \bf{5 \cdot 4^n + 1} & \bf{21} & \bf{81} & \bf{321} & \bf{1281} & \bf{5121} & \bf{20481} & \bf{81921}
                & \bf{327681} & \bf{1310721} & \bf{5242881}
                \end{array}$$
            </p>

            <p>
                Vzniká oprávnené podozrenie, že $\bf{\forall n \in N : 3 / 5 \cdot 4^n + 1}$ (t. j, že daný výraz je deliteľný
                číslom $\bf{3}$ pre každé prirodzené číslo $\bf{n}$.).
            </p>

            <p>
                Pri dôkaze použijeme niečo ako <b>„dominový efekt“</b>. Predstavme si, že máme za sebou postavených neobmedzene
                veľa kúskov domina. Predpokladajme, že sú pravdivé 2 tvrdenia:

                <ol type="a">
                    <li>
            <p>
                Spadne prvý kúsok.
            </p>
            </li>

            <li>
                <p>
                    Ak spadne niektorý kúsok, tak spadne aj za ním v rade nasledujúci kúsok.
                </p>
            </li>
            </ol>
            </p>

            <p>
                Myslím, že je zrejmé, že ak sú obe tvrdenia pravdivé, tak spadnú všetky kúsky domina
                <sup><dfn title="Uvedomte si, že „dominový efekt“ je len inak vysloveným piatym Peanovým axiómom. Niekedy sa
                    používa aj táto podoba vlastnosti b. : Ak spadnú všetky kúsky od 1 až po n, tak spadne aj n+1 kúsok.">[14]
                    </dfn></sup>.
            </p>

            <p>
                Overiť tvrdenie <b>a.</b> v našom prípade znamená zistiť či $\bf{3 / 5 \cdot 4^n + 1}$  je pravda pre
                $\bf{n = 1}$. To je zrejmé, lebo $\bf{5 \cdot 4^1 + 1 = 21 = 3 \cdot 7}$.
            </p>

            <p>
                Overiť tvrdenie <b>b.</b> znamená pre ľubovoľné $\bf{k \geq 1}$ dokázať, že ak $\bf{5 \cdot 4^k + 1}$ je násobkom
                čísla $\bf{3}$ (t. j. ak spadne ľubovoľný kúsok domina), tak aj $\bf{5.4^{k+1} + 1}$ je násobkom čísla $\bf{3}$
                (tak spadne aj nasledujúci kúsok domina).
            </p>

            <p>
                Pre sprehľadnenie našich úvah si označme: $\bf{5 \cdot 4^k + 1 = V(k)}$, potom $\bf{V(k+1) = 5 \cdot 4^{k+1} + 1}$.
            </p>

            <p>
                Zrejme $\bf{V(k+1) – V(k) = (5 \cdot 46{k+1} + 1) – (5 \cdot 4^k + 1) = 5 \cdot 4 \cdot 4^k – 5 \cdot 4^k =
                15 \cdot 4^k = 3}$.☺
            </p>

            <p>
                Inak napísané $\bf{V(k+1) = V(k) + 3}$.☺ Z čoho je zrejmé, že ak $\bf{V(k)}$ je násobkom troch, potom aj
                $\bf{V(k+1)}$ je násobkom troch.
            </p>

            <p>
                Tým sme overili podmienku <b>b.</b>, takže podľa „dominového efektu“, alebo správnejšie pomocou princípu
                matematickej indukcie sme dokázali tvrdenie: $\bbox[yellow]{\bf{\forall n \in N : 3 / 5 \cdot 4 n + 1}}$.
            </p>
        </div><br>

        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="16">
                <li>
                    <p>
                        Na základe priloženej tabuľky je možné vysloviť hypotézu: $\bf{\forall n \in N : 7 / 2^{n + 1} + 3^{2n – 1}}$.

                        $$\begin{array}{|c|c|}
                        \hline \bf{n} & \bf{1} & \bf{2} & \bf{3} & \bf{4} & \bf{5} & \bf{6} & \bf{7} & \bf{8} \\
                        \hline \bf{2^{n+1} + 3^{2n - 1}} & \bf{7} & \bf{35} & \bf{259} & \bf{2219} & \bf{19747} & \bf{177275}
                        & \bf{1594579} & \bf{14349419} \\
                        \hline \bf{(2^{n+1} + 3^{2n - 1})/7} & \bf{1} & \bf{5} & \bf{37} & \bf{317} & \bf{2821} & \bf{25325}
                        & \bf{227797} & \bf{2049917} \\ \hline
                        \end{array}$$
                    </p>

                    <p>
                        Dokážte ju matematickou indukciou.
                    </p>
                </li>

                <li>
                    <p>
                        Otvorte si Excelovský zošit Experiment D a pokúste sa vyrábať podobné úlohy ako je Príklad 8.
                        <details class="detail">
                            <summary class="summary"><b>Experiment D</b></summary>
                            <iframe scrolling="no" title="A1.14" src="https://www.geogebra.org/material/iframe/id/yanjjdnf/width/1100/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1100px" height="600px" style="border:0px;"> </iframe>
                        </details>
                    </p>
                </li>
            </ol>
        </div>

        <p>
            V závere nášho rozprávania o prirodzených číslach si dokážme ešte jedno tvrdenie, ktoré budeme neskôr potrebovať.
        </p>

        <div class="priklad">
            <h3>
                Príklad 9.
            </h3>

            <p>
                Matematickou indukciou dokážte:	$\bf{\forall n \in N : \sum_{k=1}^n k^2 = \frac{n(n + 1)(2n + 1)}{6}} \qquad (☻)$.
            </p>

            <p>
                Na vysvetlenie – symbolom $\bf{\sum_{k=1}^n k^2}$  označujeme súčet $\bf{1^2 + 2^2 + ... + n^2}$ , t. j. súčet
                štvorcov prvých $n$ prirodzených čísel<sup><dfn title="Ako sme k hypotéze (☻) došli a o význame tejto rovnosti
                    sa dozviete v ďalších kapitolách.">[15]
                    </dfn></sup>.
            </p>

            <p>
                Podľa princípu matematickej indukcie musíme:

                <ol type="a">
                    <li>
            <p>
                dokázať platnosť tvrdenia ☻ pre $\bf{n = 1}$. To ale platí, lebo $\bf{Ľ = 1^2 = 1, P =
                \frac{1 \cdot 2 \cdot 3}{6} = 1}$
            </p>
            </li>

            <li>
                <p>
                    Musíme ukázať, že pre ľubovoľné $\bf{m}$ ak platí $\bf{1^2 + 2^2 + ... + m^2 =
                    \frac{m(m+1)(2m+1)}{6}} \qquad (IP)$<sup><dfn title="Tomuto hovoríme indukčný predpoklad.">[16]
                        </dfn></sup>, tak potom platí aj:

                    $$\bf{1^2 + 2^2 + ... + m^2 + (m + 1)^2 = \frac{(m+1)((m+1)+1)(2(m+1)+1)}{6} =
                    \frac{(m+1)(m+2)(m+3)}{6}}$$
                </p>

                <p>
                    Vyjdime z IP: $\bf{1^2 + 2^2 + ... + m^2 = \frac{m(m+1)(2m+1)}{6}}$ po pripočítaní výrazu
                    $\bf{(m+1)^2}$ k obom stranám a po úpravách pravej strany dostávame: <br>

                    $$\bf{1^2 + 2^2 + ... + m^2 + (m+1)^2 = \frac{m(m+1)(2m+1)+6(m+1)^2}{6} = }$$
                    $$\bf{\frac{(m+1)[m(2m+1)+6(m+1)]}{6} = \frac{(m+1)[2m^2+7m+6]}{6} = \frac{(m+1)(m+2)(2m+3)}{6}}$$

                    čo sme chceli dokázať.
                </p>
            </li>
            </ol>
            </p>

        </div>
        <br>
        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="18">
                <li>
                    <p>
                        Vyslovte hypotézu, čomu sa rovná súčet $\bf{\sum_{k=1}^n k(k + 1)}$.
                    </p>

                </li>

                <li>
                    <p>
                        Matematickou indukciou dokážte tvrdenie: $\bf{\forall n \in N, \forall p \gt - 1: (1 + p)^n \geq 1 + n \cdot p}$.
                    </p>
                </li>
            </ol>
        </div>

    </section>
    <div class="pagination">
        <a href="A11_5.php">&laquo;</a>
        <a href="A11_1.php">1</a>
        <a href="A11_2.php">2</a>
        <a href="A11_3.php">3</a>
        <a href="A11_4.php">4</a>
        <a href="A11_5.php">5</a>
        <a class="active" href="A11_6.php">6</a>
        <a href="A11_1.php">&raquo;</a>
    </div>


</div>
</div>
</body>
<?php
include('footer.html')
?>
</html>
