<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA12.html');
?>

<div class="item2">
    <h2>1.2. Racionálne čísla</h2>

    <section>
        <p>
            Prirodzené čísla vznikli abstrakciou procesu spočítavania konečných skupín objektov. No v bežnom živote nielen
            spočitjeme množstvá individuálnych objektov, ale aj <b>meriame veličiny</b>, ako sú napríklad dĺžka, obsah,
            objem, uhol, hmotnosť, čas, ... . Ak chceme zaručiť možnosť spracovávať, porovnávať, vyhodnocovať alebo inak
            využívať výsledky týchto meraní, musíme rozšíriť "obzory aritmetiky" aj o <b>číselné vyjadrenie miery</b>
            najrôznejších veličín.
        </p>

        <p>
            Pri meraní veličín tieto obvykle porovnávame s nejakou (ľubovoľne) zvolenou jednotkou
            <b><sup><dfn title="Pri tomto porovnávaní s jednotkou, čiže meraní, dodržujeme ďalšie dve zásady:
                    a. Zhodné veličiny majú rovnakú veľkosť
                    b. Ak sa veličina skladá z jednotlivých častí, tak jej veľkosť je súčtom veľkostí týchto jej častí">[1]</dfn>
                </sup></b>. (V histórii existovalo a ešte aj dnes existuje veľké množstvo jednotiek pre všetky druhy
            veličín i keď "normalizácia" v technike a vo vedách sa snaží v systéme jednotiek zabezpečiť poriadok.)
        </p>

        <p>
            Máloktorá meraná veličina je zhodná priamo so zvolenou jednotkou, alebo jej násobkom. Na obrázku porovnávame
            čiernu úsečku s dvojyardovou tyčou. Naša úsečka je dlhšia ako $1$ yard, ale kratšia ako dva yardy. Preto
            nasleduje porovnávanie s "podjednotkami" čiže s časťami danej jednotky.
        </p>

        <p>
            (Pripomeňme, že anglický yard má 3 stopy a každá stopa má 12 palcov). Naša palica má viac ako $1$ yard a $1$
            stopu, alebo matematicky vyjadrené má viac ako <b>štyri tretiny</b> yardu. Pri presnejšom meraní (v stopách)
            má asi $4$ stopy a $5$ palcov, alebo vyjadrené rečou čísel má asi $4$ celé a $5$ dvanástin stopy.

        <div class="center2"><img src="photo/p20.png" alt="obrazky"></div>
        </p>

        <p>
            Vo všeobecnosti, ak základná jednotka má $n$ jednotiek nižšieho rádu a meraná veličina je rovná $m$ takýmto
            nižším jednotkám hovoríme, že jej miera je $\boldsymbol{\frac{m}{n}}$. Tento symbol voláme <b>zlomok</b>, alebo
            <b>pomer</b> (vtedy ho označujeme $\boldsymbol{m : n}$).
        </p>

        <p>
            Potreba ďalej narábať s výsledkami meraní postupne (v priebehu dlhých storočí) viedla k abstrahovaniu od
            procesu merania a výrazy typu $\boldsymbol{\frac{m}{n}}$ sa začali považovať za plnoprávych členov rodiny čísel -
            za racionálne čísla.
        </p>

        <p>
            Zamyslime sa podrobnejšie nad najčastejšie používaným vzťahom medzi nejakou veličinou a jej číselnou mierou -
            vzťahom medzi úsečkami a ich dĺžkami. Tento vzťah je dvojstranný: </br>
            <b>Meranie dĺžok: Úsečke priradíme číslo<br> Zostrojenie úsečky danej dĺžky: Číslu priradíme úsečku</b>
        </p>

        <p>
            Na hornom obrázku sme merali dĺžku, teraz naopak zostrojme úsečku, ktorej dĺžka je napríklad $4.4$ jednotiek
            dĺžky:
        <div class="center2"><img src="photo/p21.png" alt="obrazky"></div>
        </p>

        <p>
            Keďže $\boldsymbol{4.4 = 4 \frac{2}{5}}$, jednotkovú úsečku $\boldsymbol{OJ}$ sme naniesli štyrikrát celú a z piatej sme
            pomocou podobnosti trojuholníkov zostrojili dve pätiny.
        </p>

        <p>
            "Počítanie" s úsečkami, t.j. zostrojovanie úsečiek, ktorých dĺžka je rovná súčtu, súčinu, podielu, resp.
            inému zložitejšiemu výrazu z dĺžok daných úsečiek, bolo súčasťou už antickej (gréckej) matematiky.
        </p>

        <p>
            Na nasledujúcom obrázku sme zostrojili súčet úsečiek $\boldsymbol{Oa + Ob = Oa+b}$, (čiže v našom podaní súčet čísel
            $\boldsymbol{a + b}$) takým spôsobom, že sme zostrojili stred $\boldsymbol{s}$ úsečky $\boldsymbol{ab}$ a našli sme bod $\boldsymbol{a + b}$
            ako súmerný k $\boldsymbol{O}$ podľa stredu $\boldsymbol{s}$. Táto súmernosť zaručuje, že úsečka s koncami $\boldsymbol{b, a + b}$
            je rovnako dlhá ako úsečka $\boldsymbol{Oa}$.
        </p>
        <div class="center2"><img src="photo/p22.png" alt="obrazky"></div>
        <p>
            <details class="detail">
                <summary class="summary"><b>Tu si môžete vyskúšať sčitovanie úsečiek.</b></summary><br>
                <div class="center2" id="ch48w9gu"></div>
            </details></p>


        <p>
            Na ďalšom obrázku sme zostrojili úsečku $\boldsymbol{Oab}$, ktorá je súčinom úsečiek $\boldsymbol{Oa, Ob}$. Podobnosť
            trojuholníkov $\boldsymbol{[O;a;1]}$ a $\boldsymbol{[O;a \cdot b; b']}$ zaručuje, že úsečka $\boldsymbol{Oa \cdot b}$ má dĺžku
            rovnú súčinu dĺžok úsečiek $\boldsymbol{Oa}$ a $\boldsymbol{Ob}$.
        <div class="center2"><img src="photo/p24.png" alt="obrazky"></div>

        <p>
            <details class="detail">
                <summary class="summary"><b>Tu si môžete vyskúšať násobenie úsečiek.</b></summary><br>
                <div class="center2" id="gzsefwhx"></div>
            </details></p>

        </p>

    </section>

    <div class="pagination">
        <a href="A12_4.php">&laquo;</a>
        <a class="active" href="A12_1.php">1</a>
        <a href="A12_2.php">2</a>
        <a href="A12_3.php">3</a>
        <a href="A12_4.php">4</a>
        <a href="A12_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
