<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA12.html');
?>

<div class="item2">
    <h2>1.2. Racionálne čísla</h2>

    <section>
        <h3>Záporné čísla</h3>

        <p>
            Záporné čísla dlho bojovali o svoje miesto pod slnkom. Príčinou bolo asi to, že v najvážnejších aplikáciach
            matematiky nikomu nechýbali. Napríklad Slovenská sporiteľňa ešte v sedemdesiatych rokoch minulého storočia
            používala v styku s klientmi len kladné čísla. Vaše dlhy sporiteľni boli proste označené červenou farbou.
            Výsledný stav účtu bola absolútna hodnota rozdielu súčtu modrých (kladných) čísel a súčtu červených čísel.
            Jeho farba bola taká, aká bola farba (v absolútnej hodnote) väčšieho čísla.
        </p>

        <p>
            Podobne v algebre boli rovnice väčšinou matematizáciou nejakej reálnej situácie a z kontextu úlohy obvykle
            vyplývalo, že zmysluplné riešenie musí byť kladné číslo.
        </p>

        <p>
            Najvážnejší prelom v zavedení záporných čísel znamenalo úsilie dvoch francúzskych matematikov
            <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Fermat/" target="_blank">
                    <dfn title="Pierre Fermat">2</dfn></a>,
                <a href="https://mathshistory.st-andrews.ac.uk/Biographies/Descartes/" target="_blank">
                    <dfn title="René Descartes">3</dfn></a>]</sup> v 1. polovici 17. storočia, charakterizovať číslom
            nielen veľkosť (obvykle nejakej úsečky), ale aj <b>polohu bodu na priamke</b>, alebo pomocou dvojice čísel
            <b>polohu bodu v rovine</b>, či dokonca pomocou trojice čísel <b>polohu bodu v priestore</b>. Tak sa matematici
            dopracovali k pojmom: <b>číselná os (a súradnicová sústava v rovine a v priestore, ktorými sa budeme zaoberať
                neskôr)</b>.
        </p>

        <p>
            Ak si pozorne všimnete výkresy Q++ a Qx, zistíte (ak budete voliť sčítance, či súčinitele aj na polpriamke
            opačnej k polpriamke $\bf{O1}$), že operácie sčitovania a násobenia sa dajú prirodzeným spôsobom rozšíriť
            aj na záporné čísla.

        <div class="center2"><img src="photo/p25.png" alt="obrazky"></div>
        </p>

        <p>
            <details class="detail">
                <summary class="summary"><b>Q++</b></summary><br>
                <div class="center2" id="ch48w9gu"></div>
            </details></p>

        <p>
            <details class="detail">
                <summary class="summary"><b>Qx</b></summary><br>
                <div class="center2" id="gzsefwhx"></div>
            </details></p>



        <p>
            Racionálne čísla možno zapisovať dvoma spôsobmi:
        </p>

        <ul>
            <li>
                <p>
                    ako zlomok $\bf{\frac{p}{q}}$, kde $\bf{p}$ je ľubovoľné celé (t.j. prirodzené, alebo nula, alebo
                    číslo opačné k prirodzenému) číslo a $\bf{q}$ je prirodzené číslo,
                </p>
            </li>

            <li>
                <p>
                    ako desatinné číslo.
                </p>
            </li>

        </ul>

        <p>
            Prechod od zlomku k desatinnému číslu je zrejmý - stačí použiť algoritmus nazývaný <b>písomné delenie</b>.
            Napríklad $\bf{\frac{3}{7}}$ prevedieme na desatinné číslo delením.

            $$\begin{array}
            {cc}
            3 & : & 7 & = & 0 & , & \cellcolor{lime}4 & \cellcolor{lime} 2 & \cellcolor{lime} 8 & \cellcolor{lime} 5
            & \cellcolor{lime} 7 & \cellcolor{lime} 1 & 4\\
            3 & 0\\
            & 2 & 0\\
            && 6 & 0\\
            &&& 4 & 0\\
            &&&& 5 & 0\\
            &&&&& 1 & 0\\
            &&&&&& 3 & 0\\
            &&&&&&& 2\\
            \end{array}$$


        </p>

        <p>
            Pokračovať v delení nemá zmysel, cifry sa budú opakovať. Takémuto desatinnému číslu hovoríme <b>periodické</b>,
            označujeme $\bf{0.\overline{428571}}$ a skupinu čísel $\bf{428571}$ voláme periódou.
        </p>

        <p><h3><mark>Poznámka</mark></h3>

        Podobnému zápisu ako hore, ale pri inom základe pozičnej číselnej sústavy budeme hovoriť <b>rozvoj pri základe
        </b>$\bf{b}$ (pre $\bf{b = 2}$ diadický rozvoj, pre $\bf{b = 10}$ desatinný a podobne).
        </p>

        <p>
            Podiel $\bf{\frac{3}{7}}$ realizovaný v dvojkovej sústave dáva nasledovný diadický rozvoj:

            $$\begin{array} {ccccccccccccc}
            1 & 1 & : & 1 & 1 & 1 & = & 0 & , & \cellcolor{yellow} 0 & \cellcolor{yellow} 1 & \cellcolor{yellow} 1 & 0\\
            1 & 1 & 0\\
            1 & 1 & 0 & 0\\
            & 1 & 0 & 1 & 0\\
            &&& 1 & 1 & 0\\
            \end{array}$$

        </p>

        <p>
            Uvedieme ešte príklad na opačnú činnosť - prevedenie desatinného čísla (alebo rozvoja čísla pri danom základe)
            na zlomok.
        </p>

        <p>
            <mark style="background-color: red">Nech $\bf{a = 0.123123...}$</mark>

            $$\begin{array} {cccccc}
            1 & 0 & 0 & 0 & a = & 1 & 2 & 3 & , & \bar 1 & \bar 2 & \bar 3 \\
            & & & &  a = & & & 0 & , & \bar 1 & \bar 2 & \bar 3\\
            \hline & 9 & 9 & 9 & a = & 1 & 2 & 3 &  \\
            \end{array}$$

            $$a = \frac{123}{999}$$
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol>
                <li>
                    <p>
                        Nájdite rozvoj čísel $\bf{\frac{1}{7}, \frac{1}{11}, \frac{1}{13}}$ a $\bf{\frac{1}{17}}$ pri základoch
                        $2$ a $5$.
                    </p>
                </li>

                <li>
                    <p>
                        Pri delení celého čísla $\bf{p}$ prirodzeným číslom $\bf{q}$ môže byť zvyšok najviac $\bf{q - 1}$.
                        Preto dĺžka periódy desatinného rozvoja zlomku $\bf{\frac{p}{q}}$  (v základnom tvare
                        <sup><dfn title="Zlomok je v základnom tvare, ak sú celé čísla p, q nesúdeliteľné.">[3]</dfn></sup>
                        ) je najviac $\bf{q - 1}$.
                    </p>
                    <p>
                        (Pozri napr. zlomok $\bf{\frac{3}{7}}$ ). Nájdite aspoň tri prirodzené čísla $\bf{q}$, pre ktoré má
                        desatinný rozvoj zlomku $\bf{\frac{1}{q}}$  dĺžku periódy $\bf{q - 1}$.
                    </p>
                </li>

                <li>
                    <p>
                        Nájdite číslo, ktorého diadický rozvoj je $\bf{0.\overline{101100}}$.
                    </p>
                </li>

                <li>
                    <p>
                        Číslo $\bf{142857}$ má tú vlastnosť, že pri násobení číslami $\bf{2, 3, 4, 5}$ a $\bf{6}$ sa zmení iba
                        poradie jeho cifier. Prečo?
                    </p>
                </li>

                <li>
                    <p>
                        <mark style="background: lime;"> Prémia! </mark> Otvorte si Excelovský zošit Delenie a pokúste sa zabezpečiť, aby po zadaní základu číselnej sústavy a po zadaní cifier delenca a
                        deliteľa sa automaticky uskutočnilo písomné delenie.
                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Delenie</b></summary><br>
                            <iframe scrolling="no" title="A1.15" src="https://www.geogebra.org/material/iframe/id/ewwqwesn/width/1400/height/500/border/888888/sfsb/true/smb/true/stb/true/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1400px" height="500px" style="border:0px;"> </iframe>

                        </details></p>




                </li>

                <li>
                    <p>
                        Otvorte si výkres Q++ a upravte ho tak, aby ste pomocou neho mohli graficky odčitovať  racionálne čísla.
                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Q++</b></summary><br>
                            <iframe scrolling="no" title="A1 02" src="https://www.geogebra.org/material/iframe/id/ch48w9gu/width/1400/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1400px" height="600px" style="border:0px;"> </iframe>
                        </details></p>
                </li>

                <li>
                    <p>
                        Otvorte si výkres Qx a podľa neho vytvorte výkres, v ktorom bude Cabri vykonávať grafické delenie. Svoj výsledok porovnajte s výkresom Qxx.
                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Qx</b></summary><br>
                            <iframe scrolling="no" title="A103" src="https://www.geogebra.org/material/iframe/id/gzsefwhx/width/1400/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1400px" height="600px" style="border:0px;"> </iframe>
                        </details></p>

                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Qxx</b></summary><br>
                            <div class="center2" id="tjhve8xa"></div>
                        </details></p>
                </li>
            </ol>

    </section>

    <div class="pagination">
        <a href="A12_1.php">&laquo;</a>
        <a href="A12_1.php">1</a>
        <a class="active" href="A12_2.php">2</a>
        <a href="A12_3.php">3</a>
        <a href="A12_4.php">4</a>
        <a href="A12_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"tjhve8xa","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
        applet3.inject('tjhve8xa');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
