<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA12.html');
?>

<div class="item2">
    <h2>1.2. Racionálne čísla</h2>

    <section>
        <h3>Zhrnutie vlastností racionálnych čísel</h3>

        <p>
            Všetky prirodzené čísla, ich podiely (spolu tzv. kladné racionálne čísla), čísla k týmto opačné a číslo nula spolu tvoria <b>množinu racionálnych čísel</b>.
        </p>

        <p>
            Ak si na priamke zvolíme dva body, ktoré sú obrazom čísiel $0$ a $1$, vieme každému racionálnemu číslu priradiť práve jeden bod tejto priamky.
        </p>

        <p>
            Racionálne čísla vieme sčitovať a násobiť, pričom platí: <br>
            Sčitovanie a násobenie sú asociatívne a komutatívne operácie a násobenie je distributívne vzhľadom k sčitovaniu. Ďalej:

            $$
            \begin{aligned}
            &\forall r \in Q: 0 + r = r && \forall r \in Q : 1 \cdot r = r \\
            &\forall r \in Q \; \exists s \in Q: r + s = 0 && \forall r \in Q, r \neq 0 \; \exists s \in Q: r \cdot s = 1
            \end{aligned}
            $$
        </p>

        <p>
            Vieme, že $\bf{\frac{m}{n} = \frac{n}{q} \iff m \cdot p = n \cdot q}$, ďalej vieme, že  $\bf{\forall r, s \in Q: r \lt s \iff s - r}$ je kladné číslo.
        </p>

        <p>
            Pre tieto vzťahy platí: <br>
            „$=$“ je vzťah reflexívny, symetrický a tranzitívny  <sup><dfn title="t.j. každé číslo sa rovná sebe, ak a = b tak aj b = a, ak a = b a b = c tak aj a = c">[4]</dfn></sup>
            , vzťah „$\lt$“ je tranzitívny a:

            $$
            \begin{aligned}
            & \forall r, s, t \in Q: (r = s) \rightarrow (r + t = s + t) \land (r \cdot t = s \cdot t) \\
            & \forall r, s, t \in Q: (r \lt s) \rightarrow (r + t \lt s + t) \land \forall r, s, t \in Q t \gt 0: (r \lt s) \rightarrow (r \cdot t \lt s \cdot t) \\
            & \forall r, s \in Q: (r \lt s) \lor (r = s) \lor (r \gt s)
            \end{aligned}
            $$
        </p>

        <p>
            Tieto vlastnosti nie sú nedôležité. Vďaka nim môžeme napr. riešiť ľubovoľné lineárne rovnice a nerovnice aj ich sústavy.
        </p>

        <p>
            Treba si uvedomiť podstatný rozdiel medzi usporiadaním prirodzených a racionálnych čísel. Kým každé prirodzené číslo $\bf{n}$ malo svojho bezprostredného nasledovníka
            $\bf{n + 1}$, nemá zmysel hovoriť o „susedných“ racionálnych číslach. Medzi ľubovoľne blízkymi racionálnymi číslami $\bf{r, s}$ sa nachádza aspoň jedno ďalšie
            racionálne číslo $\bf{\frac{r + s}{2}}$. Medzi ním a číslom $r$ sa nachádza ďalšie, atď. čiže medzi ľubovoľnými dvoma racionálnymi číslami sa nachádza neobmedzene
            veľa racionálnych čísel. Tomu hovoríme, že racionálne čísla sú na číselnej osi usporiadané „husto“. Zdá sa, že racionálne čísla sú ideálny prostriedok na popis nášho
            sveta, na meranie veličín, na určovanie polohy a podobne.
        </p>

        <p>
            Toto všetko o racionálnych číslach vedeli už Pytagorovi súčasníci. Predstavte si, aké bolo ich zdesenie, keď zistili, že na číselnej osi sú aj také body, ktoré
            <b>nie sú obrazom žiadneho racionálneho čísla</b>.
        </p>

        <p>
            Doteraz sme hovorili o číslach prirodzených, celých a racionálnych, o operáciách s nimi a ich vlastnostiach. Pripomeňme si obvyklé názvy pre tieto množiny čísel
            – $\mathbb{N}$ pre čísla prirodzené, $\mathbb{Z}$ pre celé a $\mathbb{Q}$ pre čísla racionálne. V závere tejto kapitoly rozšírime operácie s číslami o pojem <b>mocniny</b>.
        </p>

        <p>
            Vieme, že symbolom $\bf{\bbox[yellow]{a^n}}$ označujeme súčin $n$ rovnakých činiteľov $\bf{a}$. Keďže ale vynásobiť vieme len <b>dve</b> čísla, aj <b>výsledok $\bf{a^n}$ môže vzniknúť len postupne,</b>
            presnejšie platí :
            $$
            \bbox[cyan, 2px]{\bf{\forall a \in R \; \forall n \in N: a^1 = a \land a^{n + 1} = a \cdot a^n} \qquad (DN)}
            $$
        </p>

        <p>
            Vzhľadom na to, že v mocnine $\bf{a^n}$ je $n \in N$, hovoríme o mocninách s prirodzeným exponentom. Uvedená definícia má tú výhodu, že umožňuje (metódou matematickej indukcie)
            dokázať známe vlastnosti mocnín (budeme ich označovať $VN$ ):
            $$
            \forall a,b \in R \; \forall k, m \in N: (a \cdot b)^k = a^k \cdot b^k \land a^k \cdot a^m = a^{k +m} \land \bigl(a^k\bigr)^m = a^{k \cdot m}$$
            $$
            \begin{array}{|c|c|c|}\hline
            &  & b^{k - m} \; ak \; k \gt m \\
            & \nearrow & \\
            \forall a,b \in R, b \neq 0 \; \forall k, m \in N: \biggl(\frac{a}{b}\biggr)^k = \frac{a^k}{b^k} \land \frac{b^k}{b^m} = & \rightarrow & 1 \; ak \; k = m \\
            & \searrow & \\
            & & \frac{1}{b^{m - k}} \; ak \; k \lt m \\ \hline
            \end{array}
            $$
        </p>

        <p>
            Posledná vlastnosť inšpiruje rozšíriť pojem mocniny aj o záporné exponenty:
            $$
            \bbox[cyan, 2px]{\bf{\forall a \in R, a \neq 0 \; \forall k \in N: a^{-k} = \frac{1}{a^k}\land a^0 = 1 \qquad (DZ)}}
            $$
        </p>

        <p>
            Vďaka tejto definícii pre mocniny s celočíselným exponentom platí:
            $$
            \bbox[yellow, 5px]{\bf{\forall a, b \in R, a, b \neq 0 \; \forall k,m \in Z: (a \cdot b)^k = a^k \cdot b^k \land a^k \cdot a^m = a^{k + m} \land \bigl(a^k\bigr)^m = a^{k \cdot m}}}
            $$

        </p>

        <p>
            Dôkazy uvedených tvrdení sú pekným cvičením na rozvíjanie kritického myslenia.
        </p>

        <div class="priklad">
            <h3>Príklad 1.</h3>
            <p>
                Matematickou indukciou dokážte: $\bf{\forall a, b \in R \; \forall k, m \in N: \bbox[yellow, 5px]{(a \cdot b)^k = a^k \cdot b^k} \land \bbox[cyan, 5px]{a^k \cdot a^m = a^{k + m} } }$
            </p>

            <h3>Riešenie</h3>
            <ol>
                <li>
                    <p>
                        Pre $\bf{n = 1} $ žltá rovnosť zrejme platí.
                    </p>
                </li>

                <li>
                    <p>
                        $\bf{(a \cdot b)^{k + 1} \overset{(podľa \; DN)}{=}}$ $\bf{(a \cdot b)^k \cdot (a \cdot b) \overset{(podľa \; IP)}{=}}$ $\bf{a^k \cdot b^k \cdot a \cdot b \overset{(vďaka \; asociatívnosti \; a \; komutatívnosti \; násobenia)}{=}}$
                        $\bf{(a^k \cdot b) \cdot (b^k \cdot b) \overset{(podľa \; DN)}{=}}$ $\bf{a^{k + 1} \cdot b^{k + 1} }$, čo sme chceli dokázať.
                    </p>
                </li>
            </ol>

            <p>
                Pre dôkaz modrej rovnosti si <b>„dominový efekt“</b> upravíme. Predstavme si, že máme do štvorca nastúpených neobmedzene veľa ľudí. Predpokladajme, že sú pravdivé 3 tvrdenia:
            </p>

            <ol>
                <li>
                    <p>
                        V ľavom hornom rohu stojí vojak.
                    </p>
                </li>

                <li>
                    <p>
                        Ak niekde stojí vojak, tak aj ten čo stojí za ním je vojak.
                    </p>
                </li>

                <li>
                    <p>
                        Ak niekde stojí vojak, tak aj ten čo stojí vpravo od neho je vojak.
                    </p>
                </li>
            </ol>
            <p>
                Myslím, že je zrejmé, že ak sú všetky tvrdenia pravdivé, tak všetci nastúpení ľudia sú vojaci.
            </p>

            <ol>
                <li>
                    <p>
                        podmienka hovorí, že modrá rovnosť má platiť pre $\bf{k = 1}$ a $\bf{m = 1}$, čo zrejme platí
                    </p>
                </li>

                <li>
                    <p>
                        podmienka hovorí, že ak naša rovnosť platí pre $\bf{k}$ a $\bf{m}$, tak platí aj pre $\bf{k + 1}$ a $\bf{m}$:<br>
                        $
                        \bf{a^{k+1} \cdot a^m \overset{(podľa \; DN)}{=}}$ $\bf{a ^k \cdot a \cdot a^m \overset{(vďaka \; asociatívnosti \; a \; komutatívnosti \; násobenia)}{=}}$
                        $\bf{a^k \cdot a^m \cdot a \overset{(podľa \; IP)}{=}}$ $\bf{a^{k+m} \cdot a \overset{(podľa \; DN)}{=}}$ $\bf{a^{k+m+1} = a^{k+1+m}}
                        $, čo sme chceli dokázať.
                    </p>
                </li>

                <li>
                    <p>
                        podmienka hovorí, že ak naša rovnosť platí pre $\bf{k}$ a $\bf{m}$, tak platí aj pre $\bf{k}$ a $\bf{m + 1}$ (túto časť dôkazu prenechávame láskavo čitateľovi).
                    </p>
                </li>
            </ol>
        </div>
        <br>
        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="8">
                <li>
                    <p>
                        Dokážte: $\bf{\forall a, b \in R \; \forall k,m \in N: \bigl(a^k\bigr)^m = a^{k \cdot m} }$
                    </p>
                </li>

                <li>
                    <p>
                        Použitím vlastností mocnín s prirodzeným exponentom a použitím definície DZ dokážte:<br>
                        $\bf{\forall a, b \in R, \; a, b \neq 0 \; \forall k, m \in Z: (a \cdot b)^k =}$ $\bf{a^k \cdot b^k \land a^k \cdot a^m = a^{k+m} \land \bigl(a^k\bigr)^m = a^{k \cdot m}}$
                    </p>
                </li>
            </ol>
        </div>

    </section>

    <div class="pagination">
        <a href="A12_2.php">&laquo;</a>
        <a href="A12_1.php">1</a>
        <a href="A12_2.php">2</a>
        <a class="active" href="A12_3.php">3</a>
        <a href="A12_4.php">4</a>
        <a href="A12_4.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
